package com.ximai.mes.pro.controller;

import cn.hutool.core.bean.BeanUtil;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ximai.common.annotation.Log;
import com.ximai.common.core.controller.BaseController;
import com.ximai.common.core.domain.AjaxResult;
import com.ximai.common.core.page.TableDataInfo;
import com.ximai.common.enums.BusinessType;
import com.ximai.common.utils.data.StringUtils;
import com.ximai.common.utils.poi.ExcelUtil;
import com.ximai.mes.pro.domain.ProArrange;
import com.ximai.mes.pro.domain.vo.ProArrangeQuery;
import com.ximai.mes.pro.domain.vo.proWorkOrder.ProArrangeExcelExport;
import com.ximai.mes.pro.service.IProArrangeService;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.List;

/**
 * 生产编排单Controller
 *
 * @author generator
 * @date 2024-03-01
 */
@RestController
@RequestMapping("/pro/arrange")
public class ProArrangeController extends BaseController {
    @Autowired
    private IProArrangeService proArrangeService;

    /**
     * 查询生产编排单列表
     */
    @PreAuthorize("@ss.hasPermi('pro:arrange:list')")
    @GetMapping("/list")
    public TableDataInfo list(ProArrange proArrange) {
        startPage();
        QueryWrapper<ProArrange> query = new QueryWrapper<ProArrange>();
        query.eq(StringUtils.isNotEmpty(proArrange.getArrangeCode()), "arrange_code", proArrange.getArrangeCode());
        query.eq(StringUtils.isNotEmpty(proArrange.getArrangeId()), "arrange_id", proArrange.getArrangeId());
        query.eq(StringUtils.isNotEmpty(proArrange.getGroupCode()), "group_code", proArrange.getGroupCode());
        query.eq(StringUtils.isNotEmpty(proArrange.getWorkorderCode()), "workorder_code", proArrange.getWorkorderCode());
        query.orderByAsc("arrange_code").orderByAsc("arrange_sort");
        List<ProArrange> list = proArrangeService.selectProArrangeList(query);
        return getDataTable(list);
    }

    /**
     * 查询生产编排单列表
     */
    @ApiOperation("关联工单表查询编排表（合并重复项）")
    @PreAuthorize("@ss.hasPermi('pro:arrange:list2')")
    @PostMapping("/list2")
    public TableDataInfo<ProArrange> list2(ProArrangeQuery proArrange) {
        startPage(proArrange);
        QueryWrapper<ProArrange> query = new QueryWrapper<ProArrange>();
        query.like(StringUtils.isNotEmpty(proArrange.getArrangeCode()), "t1.arrange_code", proArrange.getArrangeCode());
        query.in(proArrange.getWorkorderStatus() != null && proArrange.getWorkorderStatus().length > 0, "t2.status", proArrange.getWorkorderStatus());
        List<ProArrange> list = proArrangeService.selectJoinWorkorderGroupByArrangeCode(query);
        return getDataTable(list);
    }


    /**
     * 查询生产编排单列表
     */
    @ApiOperation("关联工单表查询编排表（合并重复项）")
    @PreAuthorize("@ss.hasPermi('pro:arrange:distinctList')")
    @PostMapping("/distinctList")
    public TableDataInfo<ProArrange> distinctList(ProArrangeQuery proArrange) {
        startPage();
        List<ProArrange> list = proArrangeService.selectDistictArrangeList(proArrange);
        return getDataTable(list);
    }

    /**
     * 查询生产编排单列表
     */
    @PreAuthorize("@ss.hasPermi('pro:arrange:list')")
    @GetMapping("/groupList")
    public TableDataInfo selectProArrangeGroupList(ProArrange proArrange) {
        startPage();
        List<ProArrange> list = proArrangeService.selectProArrangeGroupList(proArrange);
        return getDataTable(list);
    }


    /**
     * 导出生产编排单列表
     */
    @PreAuthorize("@ss.hasPermi('pro:arrange:export')")
    @Log(title = "生产编排单", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, ProArrange proArrange) {
        List<ProArrange> list = proArrangeService.selectProArrangeList(proArrange);
        List<ProArrangeExcelExport> exportList = new ArrayList<ProArrangeExcelExport>();
        list.forEach(s -> {
            ProArrangeExcelExport excelExport = new ProArrangeExcelExport();
            BeanUtil.copyProperties(s, excelExport);
            exportList.add(excelExport);
        });
        ExcelUtil<ProArrangeExcelExport> util = new ExcelUtil<ProArrangeExcelExport>(ProArrangeExcelExport.class);
        util.exportExcel(response, exportList, "生产编排单数据");
    }

    /**
     * 获取生产编排单详细信息
     */
    @PreAuthorize("@ss.hasPermi('pro:arrange:query')")
    @GetMapping(value = "/{arrangeId}")
    public AjaxResult getInfo(@PathVariable("arrangeId") Long arrangeId) {
        return AjaxResult.success(proArrangeService.selectProArrangeByArrangeId(arrangeId));
    }


    /**
     * 新增、修改生产编排单
     */
    @PreAuthorize("@ss.hasPermi('pro:combination:addorupdate')")
    @Log(title = "生产编排单", businessType = BusinessType.INSERT)
    @PostMapping("/batchAdd")
    public String batchAdd(@RequestBody List<ProArrange> proArranges) {
        return proArrangeService.batchAddProArrange(proArranges);
    }

    /**
     * 新增生产编排单
     */
    @PreAuthorize("@ss.hasPermi('pro:arrange:add')")
    @Log(title = "生产编排单", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody ProArrange proArrange) {
        return toAjax(proArrangeService.insertProArrange(proArrange));
    }

    /**
     * 修改生产编排单
     */
    @PreAuthorize("@ss.hasPermi('pro:arrange:edit')")
    @Log(title = "生产编排单", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody ProArrange proArrange) {
        return toAjax(proArrangeService.updateProArrange(proArrange));
    }

    /**
     * 删除生产编排单
     */
    @PreAuthorize("@ss.hasPermi('pro:arrange:remove')")
    @Log(title = "生产编排单", businessType = BusinessType.DELETE)
    @DeleteMapping("/{workorderIds}")
    public AjaxResult remove(@PathVariable Long[] workorderIds) {
        return toAjax(proArrangeService.deleteProArrangeByWorkorderIds(workorderIds));
    }

    /**
     * 拆分编排单
     */
    @PreAuthorize("@ss.hasPermi('pro:arrange:split')")
    @Log(title = "生产编排单", businessType = BusinessType.UPDATE)
    @PostMapping("/split")
    @ApiOperation("拆分编排单")
    public AjaxResult split(@ApiParam(value = "编排单ID集合", required = true) @RequestParam Long[] arrangeIds) {
        proArrangeService.split(arrangeIds);
        return AjaxResult.success();
    }

    /**
     * 编排追加工单
     */
    @PreAuthorize("@ss.hasPermi('pro:arrange:appendArrange')")
    @Log(title = "生产编排单", businessType = BusinessType.UPDATE)
    @PostMapping("/appendArrange")
    @ApiOperation("追加编排单")
    public AjaxResult appendArrange(@ApiParam(value = "编排单号", required = true)
                                    @RequestParam String arrangeCode, @ApiParam(value = "工单ID集合", required = true)
                                    @RequestParam Long[] workorderIds) {
        proArrangeService.appendArrange(arrangeCode, workorderIds);
        return AjaxResult.success();
    }

}
