package com.ximai.mes.pro.controller;

import com.ximai.common.annotation.Log;
import com.ximai.common.core.controller.BaseController;
import com.ximai.common.core.domain.AjaxResult;
import com.ximai.common.core.page.TableDataInfo;
import com.ximai.common.enums.BusinessType;
import com.ximai.common.utils.poi.ExcelUtil;
import com.ximai.mes.pro.domain.AppConfig;
import com.ximai.mes.pro.service.IAppConfigService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 * 作业端配置记录Controller
 *
 * @author generator
 * @date 2024-06-24
 */
@RestController
@RequestMapping("/md/appconfig")
public class AppConfigController extends BaseController {
    @Autowired
    private IAppConfigService appConfigService;

    /**
     * 查询作业端配置记录列表
     */
    @PreAuthorize("@ss.hasPermi('md:config:list')")
    @GetMapping("/list")
    public TableDataInfo list(AppConfig appConfig) {
        startPage();
        List<AppConfig> list = appConfigService.selectAppConfigList(appConfig);
        return getDataTable(list);
    }


    /**
     * 导出作业端配置记录列表
     */
    @PreAuthorize("@ss.hasPermi('md:config:export')")
    @Log(title = "作业端配置记录", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, AppConfig appConfig) {
        List<AppConfig> list = appConfigService.selectAppConfigList(appConfig);
        ExcelUtil<AppConfig> util = new ExcelUtil<AppConfig>(AppConfig.class);
        util.exportExcel(response, list, "作业端配置记录数据");
    }

    /**
     * 获取作业端配置记录详细信息
     */
    @PreAuthorize("@ss.hasPermi('md:config:query')")
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id) {
        return AjaxResult.success(appConfigService.selectAppConfigById(id));
    }

    /**
     * 获取作业端配置记录详细信息
     */
    @PreAuthorize("@ss.hasPermi('md:config:query')")
    @GetMapping(value = "/getVersion")
    public AjaxResult getVersion() {
        return AjaxResult.success(appConfigService.selectLastVersion());
    }

    /**
     * 新增作业端配置记录
     */
    @PreAuthorize("@ss.hasPermi('md:config:add')")
    @Log(title = "作业端配置记录", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody AppConfig appConfig) {
        return toAjax(appConfigService.insertAppConfig(appConfig));
    }

    /**
     * 修改作业端配置记录
     */
    @PreAuthorize("@ss.hasPermi('md:config:edit')")
    @Log(title = "作业端配置记录", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody AppConfig appConfig) {
        return toAjax(appConfigService.updateAppConfig(appConfig));
    }

    /**
     * 删除作业端配置记录
     */
    @PreAuthorize("@ss.hasPermi('md:config:remove')")
    @Log(title = "作业端配置记录", businessType = BusinessType.DELETE)
    @DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable Long[] ids) {
        return toAjax(appConfigService.deleteAppConfigByIds(ids));
    }
}
