package com.ximai.mes.od.controller;

import com.ximai.common.annotation.Log;
import com.ximai.common.core.controller.BaseController;
import com.ximai.common.core.domain.AjaxResult;
import com.ximai.common.core.page.TableDataInfo;
import com.ximai.common.enums.BusinessType;
import com.ximai.common.utils.poi.ExcelUtil;
import com.ximai.mes.od.domain.OdSalesOrder;
import com.ximai.mes.od.service.IOdSalesOrderService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 * 销售订单Controller
 *
 * @author yinjinlu
 * @date 2024-01-18
 */
@RestController
@RequestMapping("/od/salesOrder")
public class OdSalesOrderController extends BaseController {
    @Autowired
    private IOdSalesOrderService odSalesOrderService;

    /**
     * 查询销售订单列表
     */
    @PreAuthorize("@ss.hasPermi('od:salesOrder:list')")
    @GetMapping("/list")
    public TableDataInfo list(OdSalesOrder odSalesOrder) {
        startPage();
        List<OdSalesOrder> list = odSalesOrderService.selectOdSalesOrderList(odSalesOrder);
        return getDataTable(list);
    }

    /**
     * 导出销售订单列表
     */
    @PreAuthorize("@ss.hasPermi('od:salesOrder:export')")
    @Log(title = "销售订单", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, OdSalesOrder odSalesOrder) {
        List<OdSalesOrder> list = odSalesOrderService.selectOdSalesOrderList(odSalesOrder);
        ExcelUtil<OdSalesOrder> util = new ExcelUtil<OdSalesOrder>(OdSalesOrder.class);
        util.exportExcel(response, list, "销售订单数据");
    }

    /**
     * 获取销售订单详细信息
     */
    @PreAuthorize("@ss.hasPermi('od:salesOrder:query')")
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id) {
        return AjaxResult.success(odSalesOrderService.selectOdSalesOrderById(id));
    }


    /**
     * 新增销售订单
     */
    @PreAuthorize("@ss.hasPermi('od:salesOrder:add')")
    @Log(title = "销售订单", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody OdSalesOrder odSalesOrder) {
        return toAjax(odSalesOrderService.insertOdSalesOrder(odSalesOrder));
    }

    /**
     * 修改销售订单
     */
    @PreAuthorize("@ss.hasPermi('od:salesOrder:edit')")
    @Log(title = "销售订单", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody OdSalesOrder odSalesOrder) {
        return toAjax(odSalesOrderService.updateOdSalesOrder(odSalesOrder));
    }

    /**
     * 删除销售订单
     */
    @PreAuthorize("@ss.hasPermi('od:salesOrder:remove')")
    @Log(title = "销售订单", businessType = BusinessType.DELETE)
    @DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable String[] ids) {
        return toAjax(odSalesOrderService.deleteOdSalesOrderByIds(ids));
    }
}
