package com.ximai.mes.od.controller;

import com.ximai.common.annotation.Log;
import com.ximai.common.core.controller.BaseController;
import com.ximai.common.core.domain.AjaxResult;
import com.ximai.common.core.page.TableDataInfo;
import com.ximai.common.enums.BusinessType;
import com.ximai.common.utils.poi.ExcelUtil;
import com.ximai.mes.od.domain.OdPurchaseOrderDetail;
import com.ximai.mes.od.service.IOdPurchaseOrderDetailService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 * 客户采购订单Controller
 *
 * @author yinjinlu
 * @date 2024-01-23
 */
@RestController
@RequestMapping("/md/purchaseOrderDetail")
public class OdPurchaseOrderDetailController extends BaseController {
    @Autowired
    private IOdPurchaseOrderDetailService odPurchaseOrderDetailService;

    /**
     * 查询客户采购订单列表
     */
    @PreAuthorize("@ss.hasPermi('md:purchaseOrderDetail:list')")
    @GetMapping("/list")
    public TableDataInfo list(OdPurchaseOrderDetail odPurchaseOrderDetail) {
        startPage();
        List<OdPurchaseOrderDetail> list = odPurchaseOrderDetailService.selectOdPurchaseOrderDetailList(odPurchaseOrderDetail);
        return getDataTable(list);
    }

    /**
     * 导出客户采购订单列表
     */
    @PreAuthorize("@ss.hasPermi('md:purchaseOrderDetail:export')")
    @Log(title = "客户采购订单", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, OdPurchaseOrderDetail odPurchaseOrderDetail) {
        List<OdPurchaseOrderDetail> list = odPurchaseOrderDetailService.selectOdPurchaseOrderDetailList(odPurchaseOrderDetail);
        ExcelUtil<OdPurchaseOrderDetail> util = new ExcelUtil<OdPurchaseOrderDetail>(OdPurchaseOrderDetail.class);
        util.exportExcel(response, list, "客户采购订单数据");
    }

    /**
     * 获取客户采购订单详细信息
     */
    @PreAuthorize("@ss.hasPermi('md:purchaseOrderDetail:query')")
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") String id) {
        return AjaxResult.success(odPurchaseOrderDetailService.selectOdPurchaseOrderDetailById(id));
    }

    /**
     * 新增客户采购订单
     */
    @PreAuthorize("@ss.hasPermi('md:purchaseOrderDetail:add')")
    @Log(title = "客户采购订单", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody OdPurchaseOrderDetail odPurchaseOrderDetail) {
        return toAjax(odPurchaseOrderDetailService.insertOdPurchaseOrderDetail(odPurchaseOrderDetail));
    }

    /**
     * 修改客户采购订单
     */
    @PreAuthorize("@ss.hasPermi('md:purchaseOrderDetail:edit')")
    @Log(title = "客户采购订单", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody OdPurchaseOrderDetail odPurchaseOrderDetail) {
        return toAjax(odPurchaseOrderDetailService.updateOdPurchaseOrderDetail(odPurchaseOrderDetail));
    }

    /**
     * 删除客户采购订单
     */
    @PreAuthorize("@ss.hasPermi('md:purchaseOrderDetail:remove')")
    @Log(title = "客户采购订单", businessType = BusinessType.DELETE)
    @DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable String[] ids) {
        return toAjax(odPurchaseOrderDetailService.deleteOdPurchaseOrderDetailByIds(ids));
    }
}
