package com.ximai.mes.od.controller;

import com.ximai.common.annotation.Log;
import com.ximai.common.core.controller.BaseController;
import com.ximai.common.core.domain.AjaxResult;
import com.ximai.common.core.page.TableDataInfo;
import com.ximai.common.enums.BusinessType;
import com.ximai.common.utils.poi.ExcelUtil;
import com.ximai.mes.od.domain.OdPurchaseOrder;
import com.ximai.mes.od.service.IOdPurchaseOrderService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 * 客户采购订单Controller
 *
 * @author yinjinlu
 * @date 2024-01-22
 */
@RestController
@RequestMapping("/od/purchaseOrder")
public class OdPurchaseOrderController extends BaseController {
    @Autowired
    private IOdPurchaseOrderService odPurchaseOrderService;

    /**
     * 根据采购订单ID获取销售订单ID
     */
    @PreAuthorize("@ss.hasPermi('md:purchaseOrder:query')")
    @GetMapping(value = "getSalesOrder")
    public AjaxResult getSalesOrder(Long id) {
        return AjaxResult.success(odPurchaseOrderService.getSalesOrder(id));
    }

    /**
     * 查询客户采购订单列表
     */
    @PreAuthorize("@ss.hasPermi('md:purchaseOrder:list')")
    @GetMapping("/list")
    public TableDataInfo list(OdPurchaseOrder odPurchaseOrder) {
        startPage();
        List<OdPurchaseOrder> list = odPurchaseOrderService.selectOdPurchaseOrderList(odPurchaseOrder);
        return getDataTable(list);
    }

    /**
     * 导出客户采购订单列表
     */
    @PreAuthorize("@ss.hasPermi('md:purchaseOrder:export')")
    @Log(title = "客户采购订单", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, OdPurchaseOrder odPurchaseOrder) {
        List<OdPurchaseOrder> list = odPurchaseOrderService.selectOdPurchaseOrderList(odPurchaseOrder);
        ExcelUtil<OdPurchaseOrder> util = new ExcelUtil<OdPurchaseOrder>(OdPurchaseOrder.class);
        util.exportExcel(response, list, "客户采购订单数据");
    }

    /**
     * 新增客户采购订单
     */
    @PreAuthorize("@ss.hasPermi('md:purchaseOrder:add')")
    @Log(title = "客户采购订单", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody OdPurchaseOrder odPurchaseOrder) {
        return toAjax(odPurchaseOrderService.insertOdPurchaseOrder(odPurchaseOrder));
    }

    /**
     * 删除客户采购订单
     */
    @PreAuthorize("@ss.hasPermi('md:purchaseOrder:remove')")
    @Log(title = "客户采购订单", businessType = BusinessType.DELETE)
    @DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable String[] ids) {
        return toAjax(odPurchaseOrderService.deleteOdPurchaseOrderByIds(ids));
    }
}
