package com.ximai.mes.md.service.impl;

import cn.hutool.core.bean.BeanUtil;
import com.ximai.common.constant.UserConstants;
import com.ximai.common.exception.ServiceException;
import com.ximai.common.utils.data.ExceptionUtil;
import com.ximai.common.utils.data.StringUtils;
import com.ximai.mes.md.domain.MdWorkshop;
import com.ximai.mes.md.domain.MdWorkstation;
import com.ximai.mes.md.mapper.MdWorkshopMapper;
import com.ximai.mes.md.mapper.MdWorkstationMapper;
import com.ximai.mes.md.service.IMdWorkstationService;
import com.ximai.mes.md.vo.MdWorkstationVo;
import com.ximai.mes.pro.domain.ProProcess;
import com.ximai.mes.pro.domain.productionSolution.ProProductionSolutionProcess;
import com.ximai.mes.pro.domain.vo.ProProductionSolutionProcessVo;
import com.ximai.mes.pro.mapper.ProProcessMapper;
import com.ximai.mes.pro.service.productionSolution.IProProductionSolutionProcessService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;
import java.util.Objects;

/**
 * 工作中心Service业务层处理
 *
 * @date 2022-05-10
 */
@Service
public class MdWorkstationServiceImpl implements IMdWorkstationService {
    @Autowired
    private MdWorkstationMapper mdWorkstationMapper;

    @Autowired
    private IProProductionSolutionProcessService proProductionSolutionProcessService;

    @Autowired
    private MdWorkshopMapper mdWorkshopMapper;


    @Autowired
    private ProProcessMapper proProcessMapper;

    /**
     * 查询工作中心
     *
     * @param workstationId 工作中心主键
     * @return 工作中心
     */
    @Override
    public MdWorkstation selectMdWorkstationByWorkstationId(Long workstationId) {
        return mdWorkstationMapper.selectMdWorkstationByWorkstationId(workstationId);
    }

    /**
     * 查询工作中心列表
     *
     * @param mdWorkstation 工作中心
     * @return 工作中心
     */
    @Override
    public List<MdWorkstation> selectMdWorkstationList(MdWorkstation mdWorkstation) {
        return mdWorkstationMapper.selectMdWorkstationList(mdWorkstation);
    }

    @Override
    public String checkWorkStationCodeUnique(MdWorkstation mdWorkstation) {
        MdWorkstation workstation = mdWorkstationMapper.checkWorkStationCodeUnique(mdWorkstation);
        Long workstationId = mdWorkstation.getWorkstationId() == null ? -1L : mdWorkstation.getWorkstationId();
        if (StringUtils.isNotNull(workstation) && workstation.getWorkstationId().longValue() != workstationId.longValue()) {
            return UserConstants.NOT_UNIQUE;
        }
        return UserConstants.UNIQUE;
    }

    @Override
    public String checkWorkStationNameUnique(MdWorkstation mdWorkstation) {
        MdWorkstation workstation = mdWorkstationMapper.checkWorkStationNameUnique(mdWorkstation);
        Long workstationId = mdWorkstation.getWorkstationId() == null ? -1L : mdWorkstation.getWorkstationId();
        if (StringUtils.isNotNull(workstation) && workstation.getWorkstationId().longValue() != workstationId.longValue()) {
            return UserConstants.NOT_UNIQUE;
        }
        return UserConstants.UNIQUE;
    }

    /**
     * 新增工作中心
     *
     * @param mdWorkstation 工作中心
     * @return 结果
     */
    @Override
    public int insertMdWorkstation(MdWorkstation mdWorkstation) {
        return mdWorkstationMapper.insertMdWorkstation(mdWorkstation);
    }

    /**
     * 修改工作中心
     *
     * @param mdWorkstation 工作中心
     * @return 结果
     */
    @Override
    public int updateMdWorkstation(MdWorkstation mdWorkstation) {
        return mdWorkstationMapper.updateMdWorkstation(mdWorkstation);
    }

    /**
     * 批量删除工作中心
     *
     * @param workstationIds 需要删除的工作中心主键
     * @return 结果
     */
    @Override
    public int deleteMdWorkstationByWorkstationIds(Long[] workstationIds) {
        return mdWorkstationMapper.deleteMdWorkstationByWorkstationIds(workstationIds);
    }

    /**
     * 删除工作中心信息
     *
     * @param workstationId 工作中心主键
     * @return 结果
     */
    @Override
    public int deleteMdWorkstationByWorkstationId(Long workstationId) {
        return mdWorkstationMapper.deleteMdWorkstationByWorkstationId(workstationId);
    }

    /**
     * 接收EP传来的工作中心
     *
     * @param mdWorkstationVo
     * @return
     */
    @Override
    @Transactional
    public int workstationCreate(MdWorkstationVo mdWorkstationVo) {
        // 判断标识符
        char updateLog = mdWorkstationVo.getUpdateLog();
        MdWorkstation mdWorkstation = new MdWorkstation();
        BeanUtil.copyProperties(mdWorkstationVo, mdWorkstation);
        // 新增
        if (updateLog == 'I') {
            MdWorkstation mdWorkstation1 = mdWorkstationMapper.selectMdWorkstationByWorkstationCodes(mdWorkstation.getWorkstationCode());
            ExceptionUtil.checkTrueThrowException(Objects.nonNull(mdWorkstation1), "数据已经存在，不能重复添加");
            // 新增

                MdWorkshop mdWorkshop = mdWorkshopMapper.selectMdWorkshopByWorkshopCodes(mdWorkstation.getWorkshopCode());
                ExceptionUtil.checkTrueThrowException(Objects.isNull(mdWorkshop), "没有匹配到车间");
                mdWorkstation.setWorkshopId(mdWorkshop.getWorkshopId());

            if (StringUtils.isNotEmpty(mdWorkstation.getProcessCode())) {
                ProProcess proProcess = proProcessMapper.selectProProcessByProcessCodes(mdWorkstation.getProcessCode());
                ExceptionUtil.checkTrueThrowException(Objects.isNull(proProcess), "没有匹配工序");
                mdWorkstation.setProcessId(proProcess.getProcessId());
            }else{
                mdWorkstation.setProcessId(null);
            }
            insertMdWorkstation(mdWorkstation);
        } else if (updateLog == 'D') {
            MdWorkstation mdWorkstation1 = mdWorkstationMapper.selectMdWorkstationByWorkstationCodes(mdWorkstation.getWorkstationCode());
            if (Objects.isNull(mdWorkstation1)) {
                throw new ServiceException("该数据不存在");
            }
            if(mdWorkstation1.getEnableFlag().equals("N")){
                throw new ServiceException("该数据已被关闭");
            }

                ProProductionSolutionProcess proProductionSolutionProcess = new ProProductionSolutionProcess();
                proProductionSolutionProcess.setWorkstationId(mdWorkstation1.getWorkstationId());
                List<ProProductionSolutionProcessVo> proProductionSolutionProcesses = proProductionSolutionProcessService.selectProProductionSolutionProcessList(proProductionSolutionProcess);
                if (proProductionSolutionProcesses.size() != 0) {
                    throw new ServiceException("该工作中心已经使用，不能关闭");
                }
            // 关闭
            mdWorkstation.setWorkshopId(mdWorkstation1.getWorkshopId());
            mdWorkstation.setProcessId(mdWorkstation1.getProcessId());
            mdWorkstation.setWorkstationId(mdWorkstation1.getWorkstationId());
            mdWorkstationMapper.updateMdWorkstation(mdWorkstation);
            return 3;
        } else {
            // 修改
            MdWorkstation mdWorkstation1 = mdWorkstationMapper.selectMdWorkstationByWorkstationCodes(mdWorkstation.getWorkstationCode());
            mdWorkstation.setWorkstationId(mdWorkstation1.getWorkstationId());
            MdWorkshop mdWorkshop = mdWorkshopMapper.selectMdWorkshopByWorkshopCodes(mdWorkstation.getWorkshopCode());
            ExceptionUtil.checkTrueThrowException(Objects.isNull(mdWorkshop), "没有匹配到车间");
            mdWorkstation.setWorkshopId(mdWorkshop.getWorkshopId());

            if (StringUtils.isNotEmpty(mdWorkstation.getProcessCode())) {
                ProProcess proProcess = proProcessMapper.selectProProcessByProcessCodes(mdWorkstation.getProcessCode());
                ExceptionUtil.checkTrueThrowException(Objects.isNull(proProcess), "没有匹配工序");
                mdWorkstation.setProcessId(proProcess.getProcessId());
            }else{
                mdWorkstation.setProcessId(null);
            }
            updateMdWorkstation(mdWorkstation);

            return 2;
        }

        return 0;
    }

    @Override
    public List<MdWorkstation> selectWorkstationByUserId(Long userId) {
        return mdWorkstationMapper.selectWorkstationByUserIdV2(userId);
    }
}
