package com.ximai.mes.md.service.impl;

import com.ximai.common.constant.UserConstants;
import com.ximai.common.exception.ServiceException;
import com.ximai.common.utils.data.DateUtils;
import com.ximai.common.utils.data.StringUtils;
import com.ximai.mes.md.domain.MdFactory;
import com.ximai.mes.md.domain.MdWorkshop;
import com.ximai.mes.md.domain.MdWorkstation;
import com.ximai.mes.md.mapper.MdFactoryMapper;
import com.ximai.mes.md.mapper.MdWorkshopMapper;
import com.ximai.mes.md.mapper.MdWorkstationMapper;
import com.ximai.mes.md.service.IMdWorkshopService;
import com.ximai.mes.md.vo.MdWorkshopVo;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;
import java.util.Objects;

/**
 * 车间Service业务层处理
 *
 * @date 2022-05-07
 */
@Service
public class MdWorkshopServiceImpl implements IMdWorkshopService {
    @Autowired
    private MdWorkshopMapper mdWorkshopMapper;

    @Autowired
    private MdWorkstationMapper mdWorkstationMapper;

    @Autowired
    private MdFactoryMapper mdFactoryMapper;

    /**
     * 查询车间
     *
     * @param workshopId 车间主键
     * @return 车间
     */
    @Override
    public MdWorkshop selectMdWorkshopByWorkshopId(Long workshopId) {
        return mdWorkshopMapper.selectMdWorkshopByWorkshopId(workshopId);
    }

    /**
     * 查询车间列表
     *
     * @param mdWorkshop 车间
     * @return 车间
     */
    @Override
    public List<MdWorkshop> selectMdWorkshopList(MdWorkshop mdWorkshop) {
        return mdWorkshopMapper.selectMdWorkshopList(mdWorkshop);
    }

    @Override
    public String checkWorkshopCodeUnique(MdWorkshop mdWorkshop) {
        MdWorkshop workshop = mdWorkshopMapper.checkWorkshopCodeUnique(mdWorkshop);
        Long workshopId = mdWorkshop.getWorkshopId() == null ? -1L : mdWorkshop.getWorkshopId();
        if (StringUtils.isNotNull(workshop) && workshop.getWorkshopId().longValue() != workshopId.longValue()) {
            return UserConstants.NOT_UNIQUE;
        }
        return UserConstants.UNIQUE;
    }

    @Override
    public String checkWorkshopNameUnique(MdWorkshop mdWorkshop) {
        MdWorkshop workshop = mdWorkshopMapper.checkWorkshopNameUnique(mdWorkshop);
        Long workshopId = mdWorkshop.getWorkshopId() == null ? -1L : mdWorkshop.getWorkshopId();
        if (StringUtils.isNotNull(workshop) && workshop.getWorkshopId().longValue() != workshopId.longValue()) {
            return UserConstants.NOT_UNIQUE;
        }
        return UserConstants.UNIQUE;
    }

    /**
     * 新增车间
     *
     * @param mdWorkshop 车间
     * @return 结果
     */
    @Override
    public int insertMdWorkshop(MdWorkshop mdWorkshop) {
        mdWorkshop.createAction();
        return mdWorkshopMapper.insertMdWorkshop(mdWorkshop);
    }

    /**
     * 新增车间
     *
     * @param mdWorkshop 车间
     * @return 结果
     */

    public int insertMdWorkshops(MdWorkshop mdWorkshop) {
        mdWorkshop.setCreateTime(DateUtils.getNowDate());
        return mdWorkshopMapper.insertMdWorkshop(mdWorkshop);
    }

    /**
     * 修改车间
     *
     * @param mdWorkshop 车间
     * @return 结果
     */
    @Override
    public int updateMdWorkshop(MdWorkshop mdWorkshop) {
        mdWorkshop.updateAction();
        return mdWorkshopMapper.updateMdWorkshop(mdWorkshop);
    }

    /**
     * 修改车间
     *
     * @param mdWorkshop 车间
     * @return 结果
     */

    public int updateMdWorkshops(MdWorkshop mdWorkshop) {
         mdWorkshop.setUpdateTime(DateUtils.getNowDate());
        return mdWorkshopMapper.updateMdWorkshop(mdWorkshop);
    }

    /**
     * 批量删除车间
     *
     * @param workshopIds 需要删除的车间主键
     * @return 结果
     */
    @Override
    public int deleteMdWorkshopByWorkshopIds(Long[] workshopIds) {
        return mdWorkshopMapper.deleteMdWorkshopByWorkshopIds(workshopIds);
    }

    /**
     * 删除车间信息
     *
     * @param workshopId 车间主键
     * @return 结果
     */
    @Override
    public int deleteMdWorkshopByWorkshopId(Long workshopId) {
        return mdWorkshopMapper.deleteMdWorkshopByWorkshopId(workshopId);
    }

    /**
     * 车间EP传MES接口
     *
     * @param mdWorkshopVo
     * @return
     */
    @Override
    @Transactional
    public int workshopCreate(MdWorkshopVo mdWorkshopVo) {

        // TODO 车间EP传MES
        MdWorkshop mdWorkshop = new MdWorkshop();
        BeanUtils.copyProperties(mdWorkshopVo, mdWorkshop);
        int i = 0;
        if (mdWorkshopVo.getUpdateLog() == 'I') {
            //判断车间信息是否存在
            MdWorkshop mdWorkshop1 = mdWorkshopMapper.selectMdWorkshopByWorkshopCodes(mdWorkshop.getWorkshopCode());
            if(Objects.nonNull(mdWorkshop1)){
                throw new ServiceException("数据已经存在，不能重复添加");
            }
            //判断是否有工厂编码

               MdFactory mdFactory = mdFactoryMapper.selectMdFactoryByFactoryCode(mdWorkshop.getFactoryCode());
               if(Objects.isNull(mdFactory)){
                   throw new ServiceException("没有匹配到所绑定的工厂数据");
               }
               mdWorkshop.setFactoryId(mdFactory.getFactoryId());
               mdWorkshop.setCreateBy("ep");
                i = insertMdWorkshops(mdWorkshop);
        } else if (mdWorkshopVo.getUpdateLog() == 'D') {
            MdWorkshop mdWorkshop1 = mdWorkshopMapper.selectMdWorkshopByWorkshopCodes(mdWorkshop.getWorkshopCode());
            if(Objects.isNull(mdWorkshop1)){
                throw new ServiceException("该数据不存在");
            }
            if (mdWorkshop1.getEnableFlag().equals("N")) {
                throw new ServiceException("该数据已被关闭");
            }

                MdWorkstation mdWorkstation = new MdWorkstation();
                mdWorkstation.setWorkshopId(mdWorkshop1.getWorkshopId());
                List<MdWorkstation> mdWorkstations = mdWorkstationMapper.selectMdWorkstationList(mdWorkstation);
                if (mdWorkstations.size() != 0) {
                    throw new ServiceException("该信息已使用，不能关闭！");
                }
            mdWorkshop.setFactoryId(mdWorkshop1.getFactoryId());
            mdWorkshop.setWorkshopId(mdWorkshop1.getWorkshopId());
            mdWorkshopMapper.updateMdWorkshop(mdWorkshop);
            return 3;
        } else {
            MdWorkshop mdWorkshop1 = mdWorkshopMapper.selectMdWorkshopByWorkshopCodes(mdWorkshop.getWorkshopCode());
            if (StringUtils.isNotNull(mdWorkshopVo.getFactoryCode())) {
                    MdFactory mdFactory = mdFactoryMapper.selectMdFactoryByFactoryCode(mdWorkshopVo.getFactoryCode());
                    mdWorkshop.setFactoryId(mdFactory.getFactoryId());
                }
            MdFactory mdFactory = mdFactoryMapper.selectMdFactoryByFactoryCode(mdWorkshop.getFactoryCode());
            if(Objects.isNull(mdFactory)){
                throw new ServiceException("没有匹配到所绑定的工厂数据");
            }
                mdWorkshop.setFactoryId(mdFactory.getFactoryId());
                mdWorkshop.setWorkshopId(mdWorkshop1.getWorkshopId());
                mdWorkshop.setUpdateBy("ep");
                updateMdWorkshops(mdWorkshop);
            return 2;
        }
        return i;
    }
}
