package com.ximai.mes.md.service.impl;

import java.util.List;

import cn.hutool.core.bean.BeanUtil;
import com.ximai.common.exception.ServiceException;
import com.ximai.common.utils.data.DateUtils;
import com.ximai.common.utils.data.StringUtils;
import com.ximai.common.utils.bean.BeanValidators;
import com.ximai.mes.md.domain.MdSizeGroupItem;
import com.ximai.mes.md.mapper.MdSizeGroupItemMapper;
import com.ximai.mes.md.vo.MdSizeGroupVo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ximai.mes.md.mapper.MdSizeGroupMapper;
import com.ximai.mes.md.domain.MdSizeGroup;
import com.ximai.mes.md.service.IMdSizeGroupService;

import javax.validation.Validator;

/**
 * 尺码组Service业务层处理
 *
 * @author yinjinlu
 * @date 2024-01-18
 */
@Service
public class MdSizeGroupServiceImpl implements IMdSizeGroupService
{
    private static final Logger log = LoggerFactory.getLogger(MdSizeGroupServiceImpl.class);
    @Autowired
    private MdSizeGroupMapper mdSizeGroupMapper;
    @Autowired
    protected Validator validator;
    @Autowired
    private MdSizeGroupItemMapper mdSizeGroupItemMapper;

    /**
     * 查询尺码组
     *
     * @param sizeGroupId 尺码组主键
     * @return 尺码组
     */
    @Override
    public MdSizeGroup selectMdSizeGroupBySizeGroupId(Long sizeGroupId)
    {
        return mdSizeGroupMapper.selectMdSizeGroupBySizeGroupId(sizeGroupId);
    }

    /**
     * 查询尺码组列表
     *
     * @param mdSizeGroup 尺码组
     * @return 尺码组
     */
    @Override
    public List<MdSizeGroup> selectMdSizeGroupList(MdSizeGroup mdSizeGroup)
    {
        return mdSizeGroupMapper.selectMdSizeGroupList(mdSizeGroup);
    }

    /**
     * 新增尺码组
     *
     * @param mdSizeGroup 尺码组
     * @return 结果
     */
    @Override
    public int insertMdSizeGroup(MdSizeGroup mdSizeGroup)
    {
        mdSizeGroup.setCreateTime(DateUtils.getNowDate());
        return mdSizeGroupMapper.insertMdSizeGroup(mdSizeGroup);
    }

    /**
     * 修改尺码组
     *
     * @param mdSizeGroup 尺码组
     * @return 结果
     */
    @Override
    public int updateMdSizeGroup(MdSizeGroup mdSizeGroup)
    {
        mdSizeGroup.setUpdateTime(DateUtils.getNowDate());
        return mdSizeGroupMapper.updateMdSizeGroup(mdSizeGroup);
    }

    /**
     * 批量删除尺码组
     *
     * @param sizeGroupIds 需要删除的尺码组主键
     * @return 结果
     */
    @Override
    public int deleteMdSizeGroupBySizeGroupIds(Long[] sizeGroupIds)
    {
        return mdSizeGroupMapper.deleteMdSizeGroupBySizeGroupIds(sizeGroupIds);
    }

    /**
     * 删除尺码组信息
     *
     * @param sizeGroupId 尺码组主键
     * @return 结果
     */
    @Override
    public int deleteMdSizeGroupBySizeGroupId(Long sizeGroupId)
    {
        return mdSizeGroupMapper.deleteMdSizeGroupBySizeGroupId(sizeGroupId);
    }

    @Override
    public String importMdSizeGroupVo(List<MdSizeGroupVo> itemList, boolean updateSupport, String operaName) {
        if (StringUtils.isNull(itemList) || itemList.size() == 0)
        {
            throw new ServiceException("尺码组数据不能为空！");
        }
        int successNum = 0;
        int failureNum = 0;
        StringBuilder successMsg = new StringBuilder();
        StringBuilder failureMsg = new StringBuilder();
        for (MdSizeGroupVo mdSizeGroupVo : itemList)
        {
            try
            {
                // 验证是否存在
                MdSizeGroup sizeGroupDb = mdSizeGroupMapper.selectMdSizeGroupBySizeGroupCode(mdSizeGroupVo.getSizeGroupCode());
                if (StringUtils.isNull(sizeGroupDb))
                {
                    MdSizeGroup sizeGroup = new MdSizeGroup();
                    BeanUtil.copyProperties(mdSizeGroupVo,sizeGroup);
                    BeanValidators.validateWithException(validator, sizeGroup);
                    sizeGroup.setEnableFlag("Y");
                    sizeGroup.setCreateBy(operaName);
                    mdSizeGroupMapper.insertMdSizeGroupAndReturnId(sizeGroup);


                    //保存尺码组明细
                    MdSizeGroupItem mdSizeGroupItem = new MdSizeGroupItem();
                    BeanUtil.copyProperties(mdSizeGroupVo,mdSizeGroupItem);
                    mdSizeGroupItem.setSizeGroupId(sizeGroup.getSizeGroupId());
                    mdSizeGroupItemMapper.insertMdSizeGroupItem(mdSizeGroupItem);

                    successNum++;
                    successMsg.append("<br/>" + successNum + "、尺码组 " + sizeGroup.getSizeGroupName() + " 导入成功");
                }
                else if (updateSupport)
                {
                    sizeGroupDb.setUpdateBy(operaName);
                    this.updateMdSizeGroup(sizeGroupDb);

                    //保存尺码组明细
                    MdSizeGroupItem mdSizeGroupItem = new MdSizeGroupItem();
                    BeanUtil.copyProperties(mdSizeGroupVo,mdSizeGroupItem);
                    mdSizeGroupItem.setSizeGroupId(sizeGroupDb.getSizeGroupId());
                    mdSizeGroupItemMapper.insertMdSizeGroupItem(mdSizeGroupItem);

                    successNum++;
                    //successMsg.append("<br/>" + successNum + "、尺码组 " + mdItem.getItemName() + " 更新成功");
                }
                else
                {
                    failureNum++;
                    failureMsg.append("<br/>" + failureNum + "、尺码组 " + mdSizeGroupVo.getSizeGroupName() + " 已存在");
                }
            }
            catch (Exception e)
            {
                failureNum++;
                String msg = "<br/>" + failureNum + "、尺码组 " + mdSizeGroupVo.getSizeGroupName() + " 导入失败：";
                failureMsg.append(msg + e.getMessage());
                log.error(msg, e);
            }
        }
        if (failureNum > 0)
        {
            failureMsg.insert(0, "导入失败！共 " + failureNum + " 条数据格式不正确，错误如下：");
            throw new ServiceException(failureMsg.toString());
        }
        else
        {
            successMsg.insert(0, "数据已全部导入成功！共 " + successNum + " 条，数据如下：");
        }
        return successMsg.toString();
    }

    @Override
    public List<MdSizeGroupVo> selectMdSizeGroupExportList(MdSizeGroup mdSizeGroup) {
        return mdSizeGroupMapper.selectMdSizeGroupExportList(mdSizeGroup);
    }
}
