package com.ximai.mes.md.service.impl;

import java.util.List;
import com.ximai.common.utils.data.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ximai.mes.md.mapper.MdSizeGroupItemMapper;
import com.ximai.mes.md.domain.MdSizeGroupItem;
import com.ximai.mes.md.service.IMdSizeGroupItemService;

/**
 * 尺码组明细Service业务层处理
 *
 * @author yinjinlu
 * @date 2024-01-18
 */
@Service
public class MdSizeGroupItemServiceImpl implements IMdSizeGroupItemService
{
    @Autowired
    private MdSizeGroupItemMapper mdSizeGroupItemMapper;

    /**
     * 查询尺码组明细
     *
     * @param sizeGroupItemId 尺码组明细主键
     * @return 尺码组明细
     */
    @Override
    public MdSizeGroupItem selectMdSizeGroupItemBySizeGroupItemId(Long sizeGroupItemId)
    {
        return mdSizeGroupItemMapper.selectMdSizeGroupItemBySizeGroupItemId(sizeGroupItemId);
    }

    /**
     * 查询尺码组明细列表
     *
     * @param mdSizeGroupItem 尺码组明细
     * @return 尺码组明细
     */
    @Override
    public List<MdSizeGroupItem> selectMdSizeGroupItemList(MdSizeGroupItem mdSizeGroupItem)
    {
        return mdSizeGroupItemMapper.selectMdSizeGroupItemList(mdSizeGroupItem);
    }

    /**
     * 新增尺码组明细
     *
     * @param mdSizeGroupItem 尺码组明细
     * @return 结果
     */
    @Override
    public int insertMdSizeGroupItem(MdSizeGroupItem mdSizeGroupItem)
    {
        mdSizeGroupItem.setCreateTime(DateUtils.getNowDate());
        return mdSizeGroupItemMapper.insertMdSizeGroupItem(mdSizeGroupItem);
    }

    /**
     * 修改尺码组明细
     *
     * @param mdSizeGroupItem 尺码组明细
     * @return 结果
     */
    @Override
    public int updateMdSizeGroupItem(MdSizeGroupItem mdSizeGroupItem)
    {
        mdSizeGroupItem.setUpdateTime(DateUtils.getNowDate());
        return mdSizeGroupItemMapper.updateMdSizeGroupItem(mdSizeGroupItem);
    }

    /**
     * 批量删除尺码组明细
     *
     * @param sizeGroupItemIds 需要删除的尺码组明细主键
     * @return 结果
     */
    @Override
    public int deleteMdSizeGroupItemBySizeGroupItemIds(Long[] sizeGroupItemIds)
    {
        return mdSizeGroupItemMapper.deleteMdSizeGroupItemBySizeGroupItemIds(sizeGroupItemIds);
    }

    /**
     * 删除尺码组明细信息
     *
     * @param sizeGroupItemId 尺码组明细主键
     * @return 结果
     */
    @Override
    public int deleteMdSizeGroupItemBySizeGroupItemId(Long sizeGroupItemId)
    {
        return mdSizeGroupItemMapper.deleteMdSizeGroupItemBySizeGroupItemId(sizeGroupItemId);
    }
}
