package com.ximai.mes.md.service.impl;

import java.util.List;
import com.ximai.common.utils.data.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ximai.mes.md.mapper.MdSalesPaymentClauseMapper;
import com.ximai.mes.md.domain.MdSalesPaymentClause;
import com.ximai.mes.md.service.IMdSalesPaymentClauseService;

/**
 * 销售订单付款条件Service业务层处理
 *
 * @author yinjinlu
 * @date 2024-01-22
 */
@Service
public class MdSalesPaymentClauseServiceImpl implements IMdSalesPaymentClauseService
{
    @Autowired
    private MdSalesPaymentClauseMapper mdSalesPaymentClauseMapper;

    /**
     * 查询销售订单付款条件
     *
     * @param id 销售订单付款条件主键
     * @return 销售订单付款条件
     */
    @Override
    public MdSalesPaymentClause selectMdSalesPaymentClauseById(String id)
    {
        return mdSalesPaymentClauseMapper.selectMdSalesPaymentClauseById(id);
    }

    /**
     * 查询销售订单付款条件列表
     *
     * @param mdSalesPaymentClause 销售订单付款条件
     * @return 销售订单付款条件
     */
    @Override
    public List<MdSalesPaymentClause> selectMdSalesPaymentClauseList(MdSalesPaymentClause mdSalesPaymentClause)
    {
        return mdSalesPaymentClauseMapper.selectMdSalesPaymentClauseList(mdSalesPaymentClause);
    }

    /**
     * 新增销售订单付款条件
     *
     * @param mdSalesPaymentClause 销售订单付款条件
     * @return 结果
     */
    @Override
    public int insertMdSalesPaymentClause(MdSalesPaymentClause mdSalesPaymentClause)
    {
        mdSalesPaymentClause.setCreateTime(DateUtils.getNowDate());
        return mdSalesPaymentClauseMapper.insertMdSalesPaymentClause(mdSalesPaymentClause);
    }

    /**
     * 修改销售订单付款条件
     *
     * @param mdSalesPaymentClause 销售订单付款条件
     * @return 结果
     */
    @Override
    public int updateMdSalesPaymentClause(MdSalesPaymentClause mdSalesPaymentClause)
    {
        mdSalesPaymentClause.setUpdateTime(DateUtils.getNowDate());
        return mdSalesPaymentClauseMapper.updateMdSalesPaymentClause(mdSalesPaymentClause);
    }

    /**
     * 批量删除销售订单付款条件
     *
     * @param ids 需要删除的销售订单付款条件主键
     * @return 结果
     */
    @Override
    public int deleteMdSalesPaymentClauseByIds(String[] ids)
    {
        return mdSalesPaymentClauseMapper.deleteMdSalesPaymentClauseByIds(ids);
    }

    /**
     * 删除销售订单付款条件信息
     *
     * @param id 销售订单付款条件主键
     * @return 结果
     */
    @Override
    public int deleteMdSalesPaymentClauseById(String id)
    {
        return mdSalesPaymentClauseMapper.deleteMdSalesPaymentClauseById(id);
    }
}
