package com.ximai.mes.md.service;

import com.ximai.mes.md.domain.MdWorkstation;
import com.ximai.mes.md.vo.MdWorkstationVo;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 工作站Service接口
 *
 * @date 2022-05-10
 */
public interface IMdWorkstationService {
    /**
     * 查询工作站
     *
     * @param workstationId 工作站主键
     * @return 工作站
     */
    MdWorkstation selectMdWorkstationByWorkstationId(Long workstationId);

    /**
     * 查询工作站列表
     *
     * @param mdWorkstation 工作站
     * @return 工作站集合
     */
    List<MdWorkstation> selectMdWorkstationList(MdWorkstation mdWorkstation);

    /**
     * 检查编码是否存在
     *
     * @param mdWorkstation
     * @return
     */
    String checkWorkStationCodeUnique(MdWorkstation mdWorkstation);

    /**
     * 检查名称是否存在
     *
     * @param mdWorkstation
     * @return
     */
    String checkWorkStationNameUnique(MdWorkstation mdWorkstation);

    /**
     * 新增工作站
     *
     * @param mdWorkstation 工作站
     * @return 结果
     */
    int insertMdWorkstation(MdWorkstation mdWorkstation);

    /**
     * 修改工作站
     *
     * @param mdWorkstation 工作站
     * @return 结果
     */
    int updateMdWorkstation(MdWorkstation mdWorkstation);

    /**
     * 批量删除工作站
     *
     * @param workstationIds 需要删除的工作站主键集合
     * @return 结果
     */
    int deleteMdWorkstationByWorkstationIds(Long[] workstationIds);

    /**
     * 删除工作站信息
     *
     * @param workstationId 工作站主键
     * @return 结果
     */
    int deleteMdWorkstationByWorkstationId(Long workstationId);

    /**
     * 接收EP的工作中心
     */
    int workstationCreate(MdWorkstationVo mdWorkstationVo);

    /**
     * 查询人员关联工作中心
     *
     * @param userId
     * @return
     */
    List<MdWorkstation> selectWorkstationByUserId(@Param("userId") Long userId);
}
