package com.ximai.mes.md.service;

import java.util.List;
import com.ximai.mes.md.domain.MdSizeGroup;
import com.ximai.mes.md.vo.MdSizeGroupVo;

/**
 * 尺码组Service接口
 *
 * @author yinjinlu
 * @date 2024-01-18
 */
public interface IMdSizeGroupService
{
    /**
     * 查询尺码组
     *
     * @param sizeGroupId 尺码组主键
     * @return 尺码组
     */
    public MdSizeGroup selectMdSizeGroupBySizeGroupId(Long sizeGroupId);

    /**
     * 查询尺码组列表
     *
     * @param mdSizeGroup 尺码组
     * @return 尺码组集合
     */
    public List<MdSizeGroup> selectMdSizeGroupList(MdSizeGroup mdSizeGroup);

    /**
     * 新增尺码组
     *
     * @param mdSizeGroup 尺码组
     * @return 结果
     */
    public int insertMdSizeGroup(MdSizeGroup mdSizeGroup);

    /**
     * 修改尺码组
     *
     * @param mdSizeGroup 尺码组
     * @return 结果
     */
    public int updateMdSizeGroup(MdSizeGroup mdSizeGroup);

    /**
     * 批量删除尺码组
     *
     * @param sizeGroupIds 需要删除的尺码组主键集合
     * @return 结果
     */
    public int deleteMdSizeGroupBySizeGroupIds(Long[] sizeGroupIds);

    /**
     * 删除尺码组信息
     *
     * @param sizeGroupId 尺码组主键
     * @return 结果
     */
    public int deleteMdSizeGroupBySizeGroupId(Long sizeGroupId);

    String importMdSizeGroupVo(List<MdSizeGroupVo> itemList, boolean updateSupport, String operaName);

    List<MdSizeGroupVo> selectMdSizeGroupExportList(MdSizeGroup mdSizeGroup);
}
