package com.ximai.mes.md.service;

import java.util.List;
import com.ximai.mes.md.domain.MdSizeGroupItem;

/**
 * 尺码组明细Service接口
 *
 * @author yinjinlu
 * @date 2024-01-18
 */
public interface IMdSizeGroupItemService
{
    /**
     * 查询尺码组明细
     *
     * @param sizeGroupItemId 尺码组明细主键
     * @return 尺码组明细
     */
    public MdSizeGroupItem selectMdSizeGroupItemBySizeGroupItemId(Long sizeGroupItemId);

    /**
     * 查询尺码组明细列表
     *
     * @param mdSizeGroupItem 尺码组明细
     * @return 尺码组明细集合
     */
    public List<MdSizeGroupItem> selectMdSizeGroupItemList(MdSizeGroupItem mdSizeGroupItem);

    /**
     * 新增尺码组明细
     *
     * @param mdSizeGroupItem 尺码组明细
     * @return 结果
     */
    public int insertMdSizeGroupItem(MdSizeGroupItem mdSizeGroupItem);

    /**
     * 修改尺码组明细
     *
     * @param mdSizeGroupItem 尺码组明细
     * @return 结果
     */
    public int updateMdSizeGroupItem(MdSizeGroupItem mdSizeGroupItem);

    /**
     * 批量删除尺码组明细
     *
     * @param sizeGroupItemIds 需要删除的尺码组明细主键集合
     * @return 结果
     */
    public int deleteMdSizeGroupItemBySizeGroupItemIds(Long[] sizeGroupItemIds);

    /**
     * 删除尺码组明细信息
     *
     * @param sizeGroupItemId 尺码组明细主键
     * @return 结果
     */
    public int deleteMdSizeGroupItemBySizeGroupItemId(Long sizeGroupItemId);
}
