package com.ximai.mes.md.service;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ximai.common.core.domain.SapResult;
import com.ximai.common.core.domain.entity.MdItemType;
import com.ximai.mes.md.domain.MdItem;
import com.ximai.mes.md.vo.ItemUpdateMesVo;
import com.ximai.mes.md.vo.MdItemVo;
import com.ximai.mes.md.vo.SapItemVo;

import java.util.List;

public interface IMdItemService {

    /**
     * 根据条件查询物料编码
     *
     * @param mdItem
     * @return
     */
    List<MdItemVo> selectMdItemList(MdItem mdItem);

    MdItemType getItemTypeByItemId(Long id);


    /**
     * 根据主键查询物料编码
     *
     * @param itemId
     * @return
     */
    MdItem selectMdItemById(Long itemId);


    /**
     * 检查物料编码是否唯一
     *
     * @param mdItem
     * @return
     */
    String checkItemCodeUnique(MdItem mdItem);

    List<MdItem> selectListByQw(QueryWrapper<MdItem> query);

    /**
     * 检查物料名称是否唯一
     *
     * @param mdItem
     * @return
     */
    String checkItemNameUnique(MdItem mdItem);

    /**
     * 新增物料编码
     *
     * @param mdItem
     * @return
     */
    int insertMdItem(MdItem mdItem);

    /**
     * 更新物料编码
     *
     * @param mdItem
     * @return
     */
    int updateMdItem(MdItem mdItem);


    int updateMdItems(MdItem mdItem, ItemUpdateMesVo mdItemVo);


    /**
     * 批量删除物料编码
     *
     * @param itemIds
     * @return
     */
    int deleteByItemIds(Long[] itemIds);

    /**
     * 根据主键删除物料编码
     *
     * @param itemId
     * @return
     */
    int deleteByItemId(Long itemId);

    /**
     * 根据主键转正式产品
     *
     * @param itemIds
     * @return
     */
    SapResult becomeFormalProduct(Long[] itemIds);

    /**
     * 导入物料/产品
     *
     * @param itemList      物料/产品数据列表
     * @param updateSupport 是否更新支持，如果已存在，则进行更新数据
     * @param operaName     操作用户
     * @return 结果
     */
    String importMdItem(List<MdItem> itemList, boolean updateSupport, String operaName);

    int itemCreate(ItemUpdateMesVo mdItemVo);


    /**
     * sap传mes接口
     */
    int sapitemCreate(SapItemVo mdItemVo);
}

