package com.ximai.mes.md.service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.service.IService;
import java.util.List;
import java.util.Map;

import com.ximai.mes.md.domain.MdClientItem;

/**
 * 客户产品对照Service接口
 *
 * @author generator
 * @date 2024-01-25
 */
public interface IMdClientItemService extends IService<MdClientItem> {

    IPage<MdClientItem> page(Map<String, Object> params);
    /**
     * 查询客户产品对照
     *
     * @param id 客户产品对照主键
     * @return 客户产品对照
     */
    MdClientItem selectById(String id);

    /**
     * 查询客户产品对照列表
     *
     * @param mdClientItem 客户产品对照
     * @return 客户产品对照集合
     */
    List<MdClientItem> selectList(MdClientItem mdClientItem);


    /**
     * 新增客户产品对照
     *
     * @param mdClientItem 客户产品对照
     * @return 结果
     */
    Boolean insert(MdClientItem mdClientItem);

    /**
     * 修改客户产品对照
     *
     * @param mdClientItem 客户产品对照
     * @return 结果
     */
    Boolean update(MdClientItem mdClientItem);

    /**
     * 批量删除客户产品对照
     *
     * @param ids 需要删除的客户产品对照主键集合
     * @return 结果
     */
    Boolean deleteByIds(List<String> ids);

    /**
     * 删除客户产品对照信息
     *
     * @param id 客户产品对照主键
     * @return 结果
     */
    Boolean deleteById(String id);

    /**
     * 导入产品对照组
     *
     * @param mdClientItemsList
     * @param updateSupport
     * @param operaName
     * @return
     */
    String importMdClientItem(List<MdClientItem> mdClientItemsList, String clientCode, boolean updateSupport, String operaName);
}
