package com.ximai.mes.md.mapper;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ximai.mes.md.domain.MdWorkunit;
import com.ximai.mes.md.vo.MdWorkunitVo;
import org.apache.ibatis.annotations.Delete;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;

import java.util.List;

/**
 * 工作单元Mapper接口
 *
 * @author yinjinlu
 * @date 2024-01-18
 */
public interface MdWorkunitMapper {

    /**
     * 查询工作单元
     *
     * @param workunitId 工作单元主键
     * @return 工作单元
     */
    MdWorkunitVo selectMdWorkunitByWorkunitId(Long workunitId);


    /**
     * 根据ep传的工作中心编码删除数据
     *
     * @param workunitCode
     * @return
     */
    @Select("select *from md_workunit where workunit_code=#{workunitCode}")
    List<MdWorkunit> selectMdWorkunitByWorkunitCode(@Param("workunitCode") String workunitCode);

    @Select("select *from md_workunit where workunit_code=#{workunitCode}")
    MdWorkunit selectMdWorkunitByWorkunitCodes(@Param("workunitCode") String workunitCode);


    /**
     * 查询工作单元列表
     *
     * @param mdWorkunit 工作单元
     * @return 工作单元集合
     */
    List<MdWorkunitVo> selectMdWorkunitList(MdWorkunit mdWorkunit);

    List<MdWorkunitVo> selectMdWorkunitLists(MdWorkunit mdWorkunit);

    /**
     * 新增工作单元
     *
     * @param mdWorkunit 工作单元
     * @return 结果
     */
    int insertMdWorkunit(MdWorkunit mdWorkunit);

    /**
     * 修改工作单元
     *
     * @param mdWorkunit 工作单元
     * @return 结果
     */
    int updateMdWorkunit(MdWorkunit mdWorkunit);

    /**
     * 删除工作单元
     *
     * @param workunitId 工作单元主键
     * @return 结果
     */
    int deleteMdWorkunitByWorkunitId(Long workunitId);


    @Delete("delete from  md_workunit where workunit_code=#{workunitCode}")
    int deleteMdWorkunitByWorkunitCode(@Param("workunitCode") String workunitCode);


    /**
     * 批量删除工作单元
     *
     * @param workunitIds 需要删除的数据主键集合
     * @return 结果
     */
    int deleteMdWorkunitByWorkunitIds(Long[] workunitIds);

    @Select("select t1.*,t3.user_name from md_workunit t1 left join md_workstation t2 on t1.workstation_id = t2.workstation_id  left join md_workstation_worker t3 on t3.workstation_id = t2.workstation_id ${ew.customSqlSegment}")
    List<MdWorkunitVo> selectMdWorkstationListByUser(@Param("ew") QueryWrapper<MdWorkunitVo> query);


    @Select("select t1.*,t2.user_name,t2.user_id from md_workunit t1 inner join md_workunit_worker t2 on t1.workunit_id = t2.workunit_id ${ew.customSqlSegment}")
    List<MdWorkunitVo> selectMdWorkunitListByUser(@Param("ew") QueryWrapper<MdWorkunitVo> query);


    /**
     * 关联工作中心查询作业单元列表
     *
     * @param query
     * @return
     */
    @Select("select t1.*,t2.workstation_id,t2.process_id,t2.process_name,t2.workstation_code,t2.workstation_name,t2.transfer_time from md_workunit t1 left join md_workstation t2 on t1.workstation_id = t2.workstation_id \n" +
            "${ew.customSqlSegment}")
    List<MdWorkunitVo> selectMdWorkunitJoinWorkstation(@Param("ew") QueryWrapper<MdWorkunitVo> query);

    /**
     * 关联工作中心查询作业单元列表
     *
     * @param query
     * @return
     */
    @Select("select t1.*,mws.* from md_workunit t1  left join md_workstation mws on t1.workstation_id = mws.workstation_id ${ew.customSqlSegment}")
    List<MdWorkunit> selectListByQw(@Param("ew") QueryWrapper<MdWorkunit> query);

}
