package com.ximai.mes.md.domain;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.ximai.common.annotation.Excel;
import com.ximai.common.core.domain.BaseEntity;
import io.swagger.annotations.ApiModel;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.Size;
import java.util.List;
 

@Data
@ApiModel("物料基础")
public class MdItem extends BaseEntity {

    private static final long serialVersionUID = 1L;


    @TableId
    private Long itemId;
    @Excel(name = "物料/产品编码", type = Excel.Type.EXPORT)
    private String itemCode;

    private String dta;

    @Excel(name = "SAP产品编码", type = Excel.Type.ALL)
    private String sapItemCode;


    @Excel(name = "物料/产品名称", type = Excel.Type.ALL)
    private String itemName;

    @Excel(name = "规格型号", type = Excel.Type.ALL)
    private String specification;

    @Excel(name = "计量单位名称", type = Excel.Type.ALL)
    private String unitOfMeasure;

    @Excel(name = "物料/产品", type = Excel.Type.ALL)
    private String itemOrProduct;

    private Long itemTypeId;

    private String itemTypeCode;

    @Excel(name = "物料/产品分类", type = Excel.Type.ALL)
    private String itemTypeName;

    @Excel(name = "是否启用", type = Excel.Type.EXPORT, dictType = "sys_yes_no")
    private String enableFlag;
    @Excel(name = "是否安全库存", type = Excel.Type.ALL, dictType = "sys_yes_no")
    private String safeStockFlag;


    @Excel(name = "英文名称", type = Excel.Type.ALL)
    private String itemEnglishName;


    @Excel(name = "产品代号", type = Excel.Type.ALL)
    private String itemNo;


    @Excel(name = "最小库存", type = Excel.Type.ALL)
    private Double minStock;

    @Excel(name = "最大库存", type = Excel.Type.ALL)
    private Double maxStock;
    private String attr1;
    private String attr2;
    private String attr3;
    private String attr4;


    //@Excel(name = "是否正式产品", type = Excel.Type.EXPORT, dictType = "temporary_or_formal")
    private String isFormal;


    private String message;

    private String sapFactoryInfo;

    private String sapEnglishName;

    /**
     * 备注
     */
    private String remark;


    /**
     * 品牌id
     */
    @TableField(exist = false)
    private Long brandId;
    /**
     * 品牌编码
     */
    @TableField(exist = false)
    private String brandCode;
    /**
     * 品牌名称
     */
    @TableField(exist = false)
    private String brandName;
    @TableField(exist = false)
    private MdBaseInfo baseInfo;

    @TableField(exist = false)
    private MdProductLook look;

    @TableField(exist = false)
    private MdProductPublishedConf publishedConf;

    @TableField(exist = false)
    private MdSaleUnit saleUnit;
    @TableField(exist = false)
    private List<String> itemCodes;

    @TableField(exist = false)
    private List<String> sapItemCodeList;


    //@NotBlank(message = "物料产品编码不能为空")
    @Size(min = 0, max = 64, message = "物料产品编码长度不能超过64个字符")
    public String getItemCode() {
        return itemCode;
    }

    public void setItemCode(String itemCode) {
        this.itemCode = itemCode;
    }

    @NotBlank(message = "物料产品名称不能为空")
    @Size(min = 0, max = 255, message = "物料产品编码名称不能超过255个字符")
    public String getItemName() {
        return itemName;
    }

    public void setItemName(String itemName) {
        this.itemName = itemName;
    }

    @Size(min = 0, max = 500, message = "规格型号不能超过255个字符")
    public String getSpecification() {
        return specification;
    }

    public void setSpecification(String specification) {
        this.specification = specification;
    }

    @NotBlank(message = "单位不能为空")
    public String getUnitOfMeasure() {
        return unitOfMeasure;
    }

    public void setUnitOfMeasure(String unitOfMeasure) {
        this.unitOfMeasure = unitOfMeasure;
    }
}
