package com.ximai.mes.md.controller;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;

import cn.hutool.core.bean.BeanUtil;
import com.ximai.mes.md.domain.MdVehicle;
import com.ximai.mes.md.mapper.MdVehicleMapper;
import com.ximai.mes.md.vo.MdVehicleDispatchVo;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.ximai.common.annotation.Log;
import com.ximai.common.core.controller.BaseController;
import com.ximai.common.core.domain.AjaxResult;
import com.ximai.common.enums.BusinessType;
import com.ximai.mes.md.domain.MdVehicleDispatch;
import com.ximai.mes.md.service.IMdVehicleDispatchService;
import com.ximai.common.utils.poi.ExcelUtil;
import com.ximai.common.core.page.TableDataInfo;

/**
 * 派车记录Controller
 *
 * @author generator
 * @date 2024-01-25
 */
@RestController
@RequestMapping("/md/vehicleDispatch")
public class MdVehicleDispatchController extends BaseController
{
    @Autowired
    private IMdVehicleDispatchService mdVehicleDispatchService;
    @Autowired
    private MdVehicleMapper mdVehicleMapper;

    /**
     * 查询派车记录列表
     */
    @PreAuthorize("@ss.hasPermi('vehicleDispatch:dispatch:list')")
    @GetMapping("/list")
    public TableDataInfo list(MdVehicleDispatch mdVehicleDispatch)
    {
        startPage();
        List<MdVehicleDispatch> list = mdVehicleDispatchService.selectMdVehicleDispatchList(mdVehicleDispatch);
        List<Long> ids = list.stream().map(s->s.getVehicleId()).collect(Collectors.toList());
        List<MdVehicleDispatchVo> rst = new ArrayList<MdVehicleDispatchVo>();
        Map<Long, MdVehicle> vehicleMap = mdVehicleMapper.selectBatchIds(ids).stream().collect(Collectors.toMap(s->s.getVehicleId(), s->s));
        list.forEach(s->{
            MdVehicleDispatchVo temp = new MdVehicleDispatchVo();
            BeanUtil.copyProperties(s, temp);
            if(vehicleMap.containsKey(s.getVehicleId())){
                temp.setVehicleName(vehicleMap.get(s.getVehicleId()).getVehicleName());
            }
            rst.add(temp);
        });
        return getDataTable(rst);
    }

    /**
     * 导出派车记录列表
     */
    @PreAuthorize("@ss.hasPermi('vehicleDispatch:dispatch:export')")
    @Log(title = "派车记录", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, MdVehicleDispatch mdVehicleDispatch)
    {
        List<MdVehicleDispatch> list = mdVehicleDispatchService.selectMdVehicleDispatchList(mdVehicleDispatch);
        ExcelUtil<MdVehicleDispatch> util = new ExcelUtil<MdVehicleDispatch>(MdVehicleDispatch.class);
        util.exportExcel(response, list, "派车记录数据");
    }

    /**
     * 获取派车记录详细信息
     */
    @PreAuthorize("@ss.hasPermi('vehicleDispatch:dispatch:query')")
    @GetMapping(value = "/{dispatchId}")
    public AjaxResult getInfo(@PathVariable("dispatchId") Long dispatchId)
    {
        MdVehicleDispatchVo rst = new MdVehicleDispatchVo();
        MdVehicleDispatch temp = mdVehicleDispatchService.selectMdVehicleDispatchByDispatchId(dispatchId);
        MdVehicle mdVehicleDb = mdVehicleMapper.selectMdVehicleByVehicleId(temp.getVehicleId());
        if(mdVehicleDb!=null){
            rst.setVehicleName(mdVehicleDb.getVehicleName());
        }
        BeanUtil.copyProperties(temp, rst);
        return AjaxResult.success(rst);
    }

    /**
     * 新增派车记录
     */
    @PreAuthorize("@ss.hasPermi('vehicleDispatch:dispatch:add')")
    @Log(title = "派车记录", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody MdVehicleDispatch mdVehicleDispatch)
    {
        return toAjax(mdVehicleDispatchService.insertMdVehicleDispatch(mdVehicleDispatch));
    }

    /**
     * 修改派车记录
     */
    @PreAuthorize("@ss.hasPermi('vehicleDispatch:dispatch:edit')")
    @Log(title = "派车记录", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody MdVehicleDispatch mdVehicleDispatch)
    {
        return toAjax(mdVehicleDispatchService.updateMdVehicleDispatch(mdVehicleDispatch));
    }

    /**
     * 删除派车记录
     */
    @PreAuthorize("@ss.hasPermi('vehicleDispatch:dispatch:remove')")
    @Log(title = "派车记录", businessType = BusinessType.DELETE)
	@DeleteMapping("/{dispatchIds}")
    public AjaxResult remove(@PathVariable Long[] dispatchIds)
    {
        return toAjax(mdVehicleDispatchService.deleteMdVehicleDispatchByDispatchIds(dispatchIds));
    }
}
