package com.ximai.mes.md.controller;

import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.ximai.common.annotation.Log;
import com.ximai.common.core.controller.BaseController;
import com.ximai.common.core.domain.AjaxResult;
import com.ximai.common.enums.BusinessType;
import com.ximai.mes.md.domain.MdSizeGroupItem;
import com.ximai.mes.md.service.IMdSizeGroupItemService;
import com.ximai.common.utils.poi.ExcelUtil;
import com.ximai.common.core.page.TableDataInfo;

/**
 * 尺码组明细Controller
 *
 * @author yinjinlu
 * @date 2024-01-18
 */
@RestController
@RequestMapping("/md/item")
public class MdSizeGroupItemController extends BaseController
{
    @Autowired
    private IMdSizeGroupItemService mdSizeGroupItemService;

    /**
     * 查询尺码组明细列表
     */
    @PreAuthorize("@ss.hasPermi('md:item:list')")
    @GetMapping("/list")
    public TableDataInfo list(MdSizeGroupItem mdSizeGroupItem)
    {
        startPage();
        List<MdSizeGroupItem> list = mdSizeGroupItemService.selectMdSizeGroupItemList(mdSizeGroupItem);
        return getDataTable(list);
    }

    /**
     * 导出尺码组明细列表
     */
    @PreAuthorize("@ss.hasPermi('md:item:export')")
    @Log(title = "尺码组明细", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, MdSizeGroupItem mdSizeGroupItem)
    {
        List<MdSizeGroupItem> list = mdSizeGroupItemService.selectMdSizeGroupItemList(mdSizeGroupItem);
        ExcelUtil<MdSizeGroupItem> util = new ExcelUtil<MdSizeGroupItem>(MdSizeGroupItem.class);
        util.exportExcel(response, list, "尺码组明细数据");
    }

    /**
     * 获取尺码组明细详细信息
     */
    @PreAuthorize("@ss.hasPermi('md:item:query')")
    @GetMapping(value = "/{sizeGroupItemId}")
    public AjaxResult getInfo(@PathVariable("sizeGroupItemId") Long sizeGroupItemId)
    {
        return AjaxResult.success(mdSizeGroupItemService.selectMdSizeGroupItemBySizeGroupItemId(sizeGroupItemId));
    }

    /**
     * 新增尺码组明细
     */
    @PreAuthorize("@ss.hasPermi('md:item:add')")
    @Log(title = "尺码组明细", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody MdSizeGroupItem mdSizeGroupItem)
    {
        mdSizeGroupItem.setCreateBy(getUsername());
        return toAjax(mdSizeGroupItemService.insertMdSizeGroupItem(mdSizeGroupItem));
    }

    /**
     * 修改尺码组明细
     */
    @PreAuthorize("@ss.hasPermi('md:item:edit')")
    @Log(title = "尺码组明细", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody MdSizeGroupItem mdSizeGroupItem)
    {
        mdSizeGroupItem.setUpdateBy(getUsername());
        return toAjax(mdSizeGroupItemService.updateMdSizeGroupItem(mdSizeGroupItem));
    }

    /**
     * 删除尺码组明细
     */
    @PreAuthorize("@ss.hasPermi('md:item:remove')")
    @Log(title = "尺码组明细", businessType = BusinessType.DELETE)
	@DeleteMapping("/{sizeGroupItemIds}")
    public AjaxResult remove(@PathVariable Long[] sizeGroupItemIds)
    {
        return toAjax(mdSizeGroupItemService.deleteMdSizeGroupItemBySizeGroupItemIds(sizeGroupItemIds));
    }
}
