package com.ximai.mes.md.controller;

import java.util.List;
import javax.servlet.http.HttpServletResponse;

import com.ximai.mes.md.vo.MdSizeGroupVo;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.ximai.common.annotation.Log;
import com.ximai.common.core.controller.BaseController;
import com.ximai.common.core.domain.AjaxResult;
import com.ximai.common.enums.BusinessType;
import com.ximai.mes.md.domain.MdSizeGroup;
import com.ximai.mes.md.service.IMdSizeGroupService;
import com.ximai.common.utils.poi.ExcelUtil;
import com.ximai.common.core.page.TableDataInfo;
import org.springframework.web.multipart.MultipartFile;

/**
 * 尺码组Controller
 *
 * @author yinjinlu
 * @date 2024-01-18
 */
@RestController
@RequestMapping("/md/group")
public class MdSizeGroupController extends BaseController
{
    @Autowired
    private IMdSizeGroupService mdSizeGroupService;

    /**
     * 查询尺码组列表
     */
    @PreAuthorize("@ss.hasPermi('md:group:list')")
    @GetMapping("/list")
    public TableDataInfo list(MdSizeGroup mdSizeGroup)
    {
        startPage();
        List<MdSizeGroup> list = mdSizeGroupService.selectMdSizeGroupList(mdSizeGroup);
        return getDataTable(list);
    }

    /**
     * 导出尺码组列表
     */
    @PreAuthorize("@ss.hasPermi('md:group:export')")
    @Log(title = "尺码组", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, MdSizeGroup mdSizeGroup)
    {
        List<MdSizeGroupVo> list = mdSizeGroupService.selectMdSizeGroupExportList(mdSizeGroup);
        ExcelUtil<MdSizeGroupVo> util = new ExcelUtil<>(MdSizeGroupVo.class);
        util.exportExcel(response, list, "尺码组数据");
    }

    /**
     * 获取尺码组详细信息
     */
    @PreAuthorize("@ss.hasPermi('md:group:query')")
    @GetMapping(value = "/{sizeGroupId}")
    public AjaxResult getInfo(@PathVariable("sizeGroupId") Long sizeGroupId)
    {
        return AjaxResult.success(mdSizeGroupService.selectMdSizeGroupBySizeGroupId(sizeGroupId));
    }

    /**
     * 新增尺码组
     */
    @PreAuthorize("@ss.hasPermi('md:group:add')")
    @Log(title = "尺码组", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody MdSizeGroup mdSizeGroup)
    {
        mdSizeGroup.setCreateBy(getUsername());
        return toAjax(mdSizeGroupService.insertMdSizeGroup(mdSizeGroup));
    }

    /**
     * 修改尺码组
     */
    @PreAuthorize("@ss.hasPermi('md:group:edit')")
    @Log(title = "尺码组", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody MdSizeGroup mdSizeGroup)
    {
        mdSizeGroup.setUpdateBy(getUsername());
        return toAjax(mdSizeGroupService.updateMdSizeGroup(mdSizeGroup));
    }

    /**
     * 删除尺码组
     */
    @PreAuthorize("@ss.hasPermi('md:group:remove')")
    @Log(title = "尺码组", businessType = BusinessType.DELETE)
	@DeleteMapping("/{sizeGroupIds}")
    public AjaxResult remove(@PathVariable Long[] sizeGroupIds)
    {
        return toAjax(mdSizeGroupService.deleteMdSizeGroupBySizeGroupIds(sizeGroupIds));
    }

    @Log(title = "尺码组", businessType = BusinessType.IMPORT)
    @PreAuthorize("@ss.hasPermi('md:group:import')")
    @PostMapping("/importData")
    public AjaxResult importData(MultipartFile file, boolean updateSupport) throws Exception
    {
        ExcelUtil<MdSizeGroupVo> util = new ExcelUtil<>(MdSizeGroupVo.class);
        List<MdSizeGroupVo> itemList = util.importExcel(file.getInputStream());
        String operaName = getUsername();
        String message = mdSizeGroupService.importMdSizeGroupVo(itemList, true, operaName);
        return AjaxResult.success(message);
    }

    @PostMapping("/importTemplate")
    public void importTemplate(HttpServletResponse response)
    {
        ExcelUtil<MdSizeGroupVo> util = new ExcelUtil<>(MdSizeGroupVo.class);
        util.importTemplateExcel(response, "尺码组数据");
    }
}
