package com.ximai.mes.md.controller;

import com.ximai.common.annotation.Log;
import com.ximai.common.core.controller.BaseController;
import com.ximai.common.core.domain.AjaxResult;
import com.ximai.common.core.page.TableDataInfo;
import com.ximai.common.enums.BusinessType;
import com.ximai.common.utils.poi.ExcelUtil;
import com.ximai.mes.md.domain.MdSapDict;
import com.ximai.mes.md.service.IMdSapDictService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 * sap特性字典Controller
 *
 * @author yinjinlu
 * @date 2024-01-16
 */
@RestController
@RequestMapping("/md/sapDict")
public class MdSapDictController extends BaseController {
    @Autowired
    private IMdSapDictService mdSapDictService;

    /**
     * 查询sap特性字典列表
     */
    @PreAuthorize("@ss.hasPermi('md:sapDict:list')")
    @GetMapping("/list")
    public TableDataInfo list(MdSapDict mdSapDict) {
        startPage();
        List<MdSapDict> list = mdSapDictService.selectList(mdSapDict);
        return getDataTable(list);
    }

    /**
     * 导出sap特性字典列表
     */
    @PreAuthorize("@ss.hasPermi('md:sapDict:export')")
    @Log(title = "sap特性字典", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, MdSapDict mdSapDict) {
        List<MdSapDict> list = mdSapDictService.selectList(mdSapDict);
        ExcelUtil<MdSapDict> util = new ExcelUtil<MdSapDict>(MdSapDict.class);
        util.exportExcel(response, list, "sap特性字典数据");
    }

    /**
     * 获取sap特性字典详细信息
     */
    @PreAuthorize("@ss.hasPermi('md:sapDict:query')")
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") String id) {
        return AjaxResult.success(mdSapDictService.selectById(id));
    }

    /**
     * 新增sap特性字典
     */
    @PreAuthorize("@ss.hasPermi('md:sapDict:add')")
    @Log(title = "sap特性字典", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody MdSapDict mdSapDict) {
        return toAjax(mdSapDictService.insert(mdSapDict));
    }

    /**
     * 修改sap特性字典
     */
    @PreAuthorize("@ss.hasPermi('md:sapDict:edit')")
    @Log(title = "sap特性字典", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody MdSapDict mdSapDict) {
        return toAjax(mdSapDictService.update(mdSapDict));
    }

    /**
     * 删除sap特性字典
     */
    @PreAuthorize("@ss.hasPermi('md:sapDict:remove')")
    @Log(title = "sap特性字典", businessType = BusinessType.DELETE)
    @DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable String[] ids) {
        return toAjax(mdSapDictService.deleteByIds(ids));
    }
}
