package com.ximai.mes.md.controller;

import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.ximai.common.annotation.Log;
import com.ximai.common.core.controller.BaseController;
import com.ximai.common.core.domain.AjaxResult;
import com.ximai.common.enums.BusinessType;
import com.ximai.mes.md.domain.MdSalesShipmentPoint;
import com.ximai.mes.md.service.IMdSalesShipmentPointService;
import com.ximai.common.utils.poi.ExcelUtil;
import com.ximai.common.core.page.TableDataInfo;

/**
 * 销售订单装运点Controller
 *
 * @author yinjinlu
 * @date 2024-01-22
 */
@RestController
@RequestMapping("/md/point")
public class MdSalesShipmentPointController extends BaseController
{
    @Autowired
    private IMdSalesShipmentPointService mdSalesShipmentPointService;

    /**
     * 查询销售订单装运点列表
     */
    @PreAuthorize("@ss.hasPermi('md:point:list')")
    @GetMapping("/list")
    public TableDataInfo list(MdSalesShipmentPoint mdSalesShipmentPoint)
    {
        startPage();
        List<MdSalesShipmentPoint> list = mdSalesShipmentPointService.selectMdSalesShipmentPointList(mdSalesShipmentPoint);
        return getDataTable(list);
    }

    /**
     * 导出销售订单装运点列表
     */
    @PreAuthorize("@ss.hasPermi('md:point:export')")
    @Log(title = "销售订单装运点", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, MdSalesShipmentPoint mdSalesShipmentPoint)
    {
        List<MdSalesShipmentPoint> list = mdSalesShipmentPointService.selectMdSalesShipmentPointList(mdSalesShipmentPoint);
        ExcelUtil<MdSalesShipmentPoint> util = new ExcelUtil<MdSalesShipmentPoint>(MdSalesShipmentPoint.class);
        util.exportExcel(response, list, "销售订单装运点数据");
    }

    /**
     * 获取销售订单装运点详细信息
     */
    @PreAuthorize("@ss.hasPermi('md:point:query')")
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") String id)
    {
        return AjaxResult.success(mdSalesShipmentPointService.selectMdSalesShipmentPointById(id));
    }

    /**
     * 新增销售订单装运点
     */
    @PreAuthorize("@ss.hasPermi('md:point:add')")
    @Log(title = "销售订单装运点", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody MdSalesShipmentPoint mdSalesShipmentPoint)
    {
        return toAjax(mdSalesShipmentPointService.insertMdSalesShipmentPoint(mdSalesShipmentPoint));
    }

    /**
     * 修改销售订单装运点
     */
    @PreAuthorize("@ss.hasPermi('md:point:edit')")
    @Log(title = "销售订单装运点", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody MdSalesShipmentPoint mdSalesShipmentPoint)
    {
        return toAjax(mdSalesShipmentPointService.updateMdSalesShipmentPoint(mdSalesShipmentPoint));
    }

    /**
     * 删除销售订单装运点
     */
    @PreAuthorize("@ss.hasPermi('md:point:remove')")
    @Log(title = "销售订单装运点", businessType = BusinessType.DELETE)
	@DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable String[] ids)
    {
        return toAjax(mdSalesShipmentPointService.deleteMdSalesShipmentPointByIds(ids));
    }
}
