package com.ximai.mes.md.controller;

import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.ximai.common.annotation.Log;
import com.ximai.common.core.controller.BaseController;
import com.ximai.common.core.domain.AjaxResult;
import com.ximai.common.enums.BusinessType;
import com.ximai.mes.md.domain.MdSalesClause;
import com.ximai.mes.md.service.IMdSalesClauseService;
import com.ximai.common.utils.poi.ExcelUtil;
import com.ximai.common.core.page.TableDataInfo;

/**
 * 国际贸易销售条款Controller
 *
 * @author yinjinlu
 * @date 2024-01-22
 */
@RestController
@RequestMapping("/md/clause")
public class MdSalesClauseController extends BaseController
{
    @Autowired
    private IMdSalesClauseService mdSalesClauseService;

    /**
     * 查询国际贸易销售条款列表
     */
    @PreAuthorize("@ss.hasPermi('md:clause:list')")
    @GetMapping("/list")
    public TableDataInfo list(MdSalesClause mdSalesClause)
    {
        startPage();
        List<MdSalesClause> list = mdSalesClauseService.selectMdSalesClauseList(mdSalesClause);
        return getDataTable(list);
    }

    /**
     * 导出国际贸易销售条款列表
     */
    @PreAuthorize("@ss.hasPermi('md:clause:export')")
    @Log(title = "国际贸易销售条款", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, MdSalesClause mdSalesClause)
    {
        List<MdSalesClause> list = mdSalesClauseService.selectMdSalesClauseList(mdSalesClause);
        ExcelUtil<MdSalesClause> util = new ExcelUtil<MdSalesClause>(MdSalesClause.class);
        util.exportExcel(response, list, "国际贸易销售条款数据");
    }

    /**
     * 获取国际贸易销售条款详细信息
     */
    @PreAuthorize("@ss.hasPermi('md:clause:query')")
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") String id)
    {
        return AjaxResult.success(mdSalesClauseService.selectMdSalesClauseById(id));
    }

    /**
     * 新增国际贸易销售条款
     */
    @PreAuthorize("@ss.hasPermi('md:clause:add')")
    @Log(title = "国际贸易销售条款", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody MdSalesClause mdSalesClause)
    {
        return toAjax(mdSalesClauseService.insertMdSalesClause(mdSalesClause));
    }

    /**
     * 修改国际贸易销售条款
     */
    @PreAuthorize("@ss.hasPermi('md:clause:edit')")
    @Log(title = "国际贸易销售条款", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody MdSalesClause mdSalesClause)
    {
        return toAjax(mdSalesClauseService.updateMdSalesClause(mdSalesClause));
    }

    /**
     * 删除国际贸易销售条款
     */
    @PreAuthorize("@ss.hasPermi('md:clause:remove')")
    @Log(title = "国际贸易销售条款", businessType = BusinessType.DELETE)
	@DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable String[] ids)
    {
        return toAjax(mdSalesClauseService.deleteMdSalesClauseByIds(ids));
    }
}
