package com.ximai.mes.md.controller;

import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.ximai.common.annotation.Log;
import com.ximai.common.core.controller.BaseController;
import com.ximai.common.core.domain.AjaxResult;
import com.ximai.common.enums.BusinessType;
import com.ximai.mes.md.domain.MdSaleOrderType;
import com.ximai.mes.md.service.IMdSaleOrderTypeService;
import com.ximai.common.utils.poi.ExcelUtil;
import com.ximai.common.core.page.TableDataInfo;

/**
 * 销售订单类型Controller
 *
 * @author yinjinlu
 * @date 2024-01-22
 */
@RestController
@RequestMapping("/md/type")
public class MdSaleOrderTypeController extends BaseController
{
    @Autowired
    private IMdSaleOrderTypeService mdSaleOrderTypeService;

    /**
     * 查询销售订单类型列表
     */
    @PreAuthorize("@ss.hasPermi('md:type:list')")
    @GetMapping("/list")
    public TableDataInfo list(MdSaleOrderType mdSaleOrderType)
    {
        startPage();
        List<MdSaleOrderType> list = mdSaleOrderTypeService.selectMdSaleOrderTypeList(mdSaleOrderType);
        return getDataTable(list);
    }

    /**
     * 导出销售订单类型列表
     */
    @PreAuthorize("@ss.hasPermi('md:type:export')")
    @Log(title = "销售订单类型", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, MdSaleOrderType mdSaleOrderType)
    {
        List<MdSaleOrderType> list = mdSaleOrderTypeService.selectMdSaleOrderTypeList(mdSaleOrderType);
        ExcelUtil<MdSaleOrderType> util = new ExcelUtil<MdSaleOrderType>(MdSaleOrderType.class);
        util.exportExcel(response, list, "销售订单类型数据");
    }

    /**
     * 获取销售订单类型详细信息
     */
    @PreAuthorize("@ss.hasPermi('md:type:query')")
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id)
    {
        return AjaxResult.success(mdSaleOrderTypeService.selectMdSaleOrderTypeById(id));
    }

    /**
     * 新增销售订单类型
     */
    @PreAuthorize("@ss.hasPermi('md:type:add')")
    @Log(title = "销售订单类型", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody MdSaleOrderType mdSaleOrderType)
    {
        return toAjax(mdSaleOrderTypeService.insertMdSaleOrderType(mdSaleOrderType));
    }

    /**
     * 修改销售订单类型
     */
    @PreAuthorize("@ss.hasPermi('md:type:edit')")
    @Log(title = "销售订单类型", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody MdSaleOrderType mdSaleOrderType)
    {
        return toAjax(mdSaleOrderTypeService.updateMdSaleOrderType(mdSaleOrderType));
    }

    /**
     * 删除销售订单类型
     */
    @PreAuthorize("@ss.hasPermi('md:type:remove')")
    @Log(title = "销售订单类型", businessType = BusinessType.DELETE)
	@DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable Long[] ids)
    {
        return toAjax(mdSaleOrderTypeService.deleteMdSaleOrderTypeByIds(ids));
    }
}
