package com.ximai.mes.md.controller;

import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.ximai.common.annotation.Log;
import com.ximai.common.core.controller.BaseController;
import com.ximai.common.core.domain.AjaxResult;
import com.ximai.common.enums.BusinessType;
import com.ximai.mes.md.domain.MdSaleOrderOrg;
import com.ximai.mes.md.service.IMdSaleOrderOrgService;
import com.ximai.common.utils.poi.ExcelUtil;
import com.ximai.common.core.page.TableDataInfo;

/**
 * 销售订单组织Controller
 *
 * @author yinjinlu
 * @date 2024-01-22
 */
@RestController
@RequestMapping("/md/org")
public class MdSaleOrderOrgController extends BaseController
{
    @Autowired
    private IMdSaleOrderOrgService mdSaleOrderOrgService;

    /**
     * 查询销售订单组织列表
     */
    @PreAuthorize("@ss.hasPermi('md:org:list')")
    @GetMapping("/list")
    public TableDataInfo list(MdSaleOrderOrg mdSaleOrderOrg)
    {
        startPage();
        List<MdSaleOrderOrg> list = mdSaleOrderOrgService.selectMdSaleOrderOrgList(mdSaleOrderOrg);
        return getDataTable(list);
    }

    /**
     * 导出销售订单组织列表
     */
    @PreAuthorize("@ss.hasPermi('md:org:export')")
    @Log(title = "销售订单组织", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, MdSaleOrderOrg mdSaleOrderOrg)
    {
        List<MdSaleOrderOrg> list = mdSaleOrderOrgService.selectMdSaleOrderOrgList(mdSaleOrderOrg);
        ExcelUtil<MdSaleOrderOrg> util = new ExcelUtil<MdSaleOrderOrg>(MdSaleOrderOrg.class);
        util.exportExcel(response, list, "销售订单组织数据");
    }

    /**
     * 获取销售订单组织详细信息
     */
    @PreAuthorize("@ss.hasPermi('md:org:query')")
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id)
    {
        return AjaxResult.success(mdSaleOrderOrgService.selectMdSaleOrderOrgById(id));
    }

    /**
     * 新增销售订单组织
     */
    @PreAuthorize("@ss.hasPermi('md:org:add')")
    @Log(title = "销售订单组织", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody MdSaleOrderOrg mdSaleOrderOrg)
    {
        return toAjax(mdSaleOrderOrgService.insertMdSaleOrderOrg(mdSaleOrderOrg));
    }

    /**
     * 修改销售订单组织
     */
    @PreAuthorize("@ss.hasPermi('md:org:edit')")
    @Log(title = "销售订单组织", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody MdSaleOrderOrg mdSaleOrderOrg)
    {
        return toAjax(mdSaleOrderOrgService.updateMdSaleOrderOrg(mdSaleOrderOrg));
    }

    /**
     * 删除销售订单组织
     */
    @PreAuthorize("@ss.hasPermi('md:org:remove')")
    @Log(title = "销售订单组织", businessType = BusinessType.DELETE)
	@DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable Long[] ids)
    {
        return toAjax(mdSaleOrderOrgService.deleteMdSaleOrderOrgByIds(ids));
    }
}
