package com.ximai.mes.md.controller;

import cn.hutool.core.collection.CollectionUtil;
import com.ximai.common.annotation.Log;
import com.ximai.common.core.controller.BaseController;
import com.ximai.common.core.domain.AjaxResult;
import com.ximai.common.core.page.TableDataInfo;
import com.ximai.common.enums.BusinessType;
import com.ximai.common.utils.poi.ExcelUtil;
import com.ximai.mes.md.domain.MdProductSop;
import com.ximai.mes.md.mapper.MdProductSopMapper;
import com.ximai.mes.md.service.IMdProductSopService;
import com.ximai.mes.pro.domain.vo.ProWorkorderVo1;
import com.ximai.mes.pro.mapper.proWorkOrder.ProWorkorderMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.List;

/**
 * 产品SOPController
 *
 * @date 2022-07-26
 */
@RestController
@RequestMapping("/mes/md/sop")
public class MdProductSopController extends BaseController {
    @Autowired
    private IMdProductSopService mdProductSopService;

    @Autowired
    private ProWorkorderMapper proWorkorderMapper;

    @Autowired
    private MdProductSopMapper mdProductSopMapper;

    /**
     * 查询产品SOP列表
     */
    @GetMapping("/list")
    public TableDataInfo list(MdProductSop mdProdutSop) {
        startPage();
        List<MdProductSop> list = mdProductSopService.selectMdProductSopList(mdProdutSop);
        return getDataTable(list);
    }

    /**
     * 导出产品SOP列表
     */
    @PreAuthorize("@ss.hasPermi('mes:md:mditem:export')")
    @Log(title = "产品SOP", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, MdProductSop mdProdutSop) {
        List<MdProductSop> list = mdProductSopService.selectMdProductSopList(mdProdutSop);
        ExcelUtil<MdProductSop> util = new ExcelUtil<MdProductSop>(MdProductSop.class);
        util.exportExcel(response, list, "产品SOP数据");
    }

    /**
     * 获取产品SOP详细信息
     */
    @PreAuthorize("@ss.hasPermi('mes:md:mditem:query')")
    @GetMapping(value = "/{sopId}")
    public AjaxResult getInfo(@PathVariable("sopId") Long sopId) {
        return AjaxResult.success(mdProductSopService.selectMdProductSopBySopId(sopId));
    }

    /**
     * 新增产品SOP
     */
    @PreAuthorize("@ss.hasPermi('mes:md:mditem:add')")
    @Log(title = "产品SOP", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody MdProductSop mdProdutSop) {
        return toAjax(mdProductSopService.insertMdProductSop(mdProdutSop));
    }

    /**
     * 修改产品SOP
     */
    @PreAuthorize("@ss.hasPermi('mes:md:mditem:edit')")
    @Log(title = "产品SOP", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody MdProductSop mdProdutSop) {
        return toAjax(mdProductSopService.updateMdProductSop(mdProdutSop));
    }

    /**
     * 删除产品SOP
     */
    @PreAuthorize("@ss.hasPermi('mes:md:mditem:remove')")
    @Log(title = "产品SOP", businessType = BusinessType.DELETE)
    @DeleteMapping("/{sopIds}")
    public AjaxResult remove(@PathVariable Long[] sopIds) {
        return toAjax(mdProductSopService.deleteMdProductSopBySopIds(sopIds));
    }

    /**
     * pad端查看图片
     */
    @GetMapping("/getProWorkder/{workorderId}")
    public AjaxResult getProWorkderTaskID(@PathVariable("workorderId") Long workorderId) {
        List<String> sopList = new ArrayList<>();
        List<ProWorkorderVo1> proWorkorderVo1s = proWorkorderMapper.selectProWorkorderByWorkorderitem(workorderId);
        for (ProWorkorderVo1 pro : proWorkorderVo1s) {
            MdProductSop mdProductSop = new MdProductSop();
            mdProductSop.setItemId(pro.getProductId());
            List<MdProductSop> mdProductSops = mdProductSopMapper.selectMdProductSopList(mdProductSop);
            if (CollectionUtil.isNotEmpty(mdProductSops)) {
                for (MdProductSop prosop : mdProductSops) {
                    String sopUrl = prosop.getSopUrl();
                    sopList.add(sopUrl);
                }
            }

        }

        return AjaxResult.success(sopList);
    }
}
