package com.ximai.mes.md.controller;

import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.ximai.common.annotation.Log;
import com.ximai.common.core.controller.BaseController;
import com.ximai.common.core.domain.AjaxResult;
import com.ximai.common.enums.BusinessType;
import com.ximai.mes.md.domain.MdProductPublishedConf;
import com.ximai.mes.md.service.IMdProductPublishedConfService;
import com.ximai.common.utils.poi.ExcelUtil;
import com.ximai.common.core.page.TableDataInfo;

/**
 * 产品打样排版参数配置Controller
 *
 * @author yinjinlu
 * @date 2024-01-17
 */
@RestController
@RequestMapping("/md/conf")
public class MdProductPublishedConfController extends BaseController
{
    @Autowired
    private IMdProductPublishedConfService mdProductPublishedConfService;

    /**
     * 查询产品打样排版参数配置列表
     */
    @PreAuthorize("@ss.hasPermi('md:conf:list')")
    @GetMapping("/list")
    public TableDataInfo list(MdProductPublishedConf mdProductPublishedConf)
    {
        startPage();
        List<MdProductPublishedConf> list = mdProductPublishedConfService.selectMdProductPublishedConfList(mdProductPublishedConf);
        return getDataTable(list);
    }

    /**
     * 导出产品打样排版参数配置列表
     */
    @PreAuthorize("@ss.hasPermi('md:conf:export')")
    @Log(title = "产品打样排版参数配置", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, MdProductPublishedConf mdProductPublishedConf)
    {
        List<MdProductPublishedConf> list = mdProductPublishedConfService.selectMdProductPublishedConfList(mdProductPublishedConf);
        ExcelUtil<MdProductPublishedConf> util = new ExcelUtil<MdProductPublishedConf>(MdProductPublishedConf.class);
        util.exportExcel(response, list, "产品打样排版参数配置数据");
    }

    /**
     * 获取产品打样排版参数配置详细信息
     */
    @PreAuthorize("@ss.hasPermi('md:conf:query')")
    @GetMapping(value = "/{itemId}")
    public AjaxResult getInfo(@PathVariable("itemId") Long itemId)
    {
        return AjaxResult.success(mdProductPublishedConfService.selectMdProductPublishedConfByItemId(itemId));
    }

    /**
     * 新增产品打样排版参数配置
     */
    @PreAuthorize("@ss.hasPermi('md:conf:add')")
    @Log(title = "产品打样排版参数配置", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody MdProductPublishedConf mdProductPublishedConf)
    {
        return toAjax(mdProductPublishedConfService.insertMdProductPublishedConf(mdProductPublishedConf));
    }

    /**
     * 修改产品打样排版参数配置
     */
    @PreAuthorize("@ss.hasPermi('md:conf:edit')")
    @Log(title = "产品打样排版参数配置", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody MdProductPublishedConf mdProductPublishedConf)
    {
        return toAjax(mdProductPublishedConfService.updateMdProductPublishedConf(mdProductPublishedConf));
    }

    /**
     * 删除产品打样排版参数配置
     */
    @PreAuthorize("@ss.hasPermi('md:conf:remove')")
    @Log(title = "产品打样排版参数配置", businessType = BusinessType.DELETE)
	@DeleteMapping("/{itemIds}")
    public AjaxResult remove(@PathVariable Long[] itemIds)
    {
        return toAjax(mdProductPublishedConfService.deleteMdProductPublishedConfByItemIds(itemIds));
    }
}
