package com.ximai.mes.md.controller;

import java.util.List;
import javax.servlet.http.HttpServletResponse;

import com.ximai.mes.md.vo.MdProductLossVo;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.ximai.common.annotation.Log;
import com.ximai.common.core.controller.BaseController;
import com.ximai.common.core.domain.AjaxResult;
import com.ximai.common.enums.BusinessType;
import com.ximai.mes.md.domain.MdProductLoss;
import com.ximai.mes.md.service.IMdProductLossService;
import com.ximai.common.utils.poi.ExcelUtil;
import com.ximai.common.core.page.TableDataInfo;

/**
 * 产品loss配置Controller
 *
 * @author yinjinlu
 * @date 2024-01-17
 */
@RestController
@RequestMapping("/md/loss")
public class MdProductLossController extends BaseController
{
    @Autowired
    private IMdProductLossService mdProductLossService;

    /**
     * 查询产品loss配置列表
     */
    @PreAuthorize("@ss.hasPermi('md:loss:list')")
    @GetMapping("/list")
    public TableDataInfo list(MdProductLoss mdProductLoss)
    {
        startPage();
        List<MdProductLossVo> list = mdProductLossService.selectMdProductLossList(mdProductLoss);
        return getDataTable(list);
    }

    /**
     * 导出产品loss配置列表
     */
    @PreAuthorize("@ss.hasPermi('md:loss:export')")
    @Log(title = "产品loss配置", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, MdProductLoss mdProductLoss)
    {
        List<MdProductLossVo> list = mdProductLossService.selectMdProductLossList(mdProductLoss);
        ExcelUtil<MdProductLossVo> util = new ExcelUtil<MdProductLossVo>(MdProductLossVo.class);
        util.exportExcel(response, list, "产品loss配置数据");
    }

    /**
     * 获取产品loss配置详细信息
     */
    @PreAuthorize("@ss.hasPermi('md:loss:query')")
    @GetMapping(value = "/{productLossId}")
    public AjaxResult getInfo(@PathVariable("productLossId") Long productLossId)
    {
        return AjaxResult.success(mdProductLossService.selectMdProductLossByProductLossId(productLossId));
    }

    /**
     * 新增产品loss配置
     */
    @PreAuthorize("@ss.hasPermi('md:loss:add')")
    @Log(title = "产品loss配置", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody MdProductLoss mdProductLoss)
    {
        mdProductLoss.setCreateBy(getUsername());
        return toAjax(mdProductLossService.insertMdProductLoss(mdProductLoss));
    }

    /**
     * 修改产品loss配置
     */
    @PreAuthorize("@ss.hasPermi('md:loss:edit')")
    @Log(title = "产品loss配置", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody MdProductLoss mdProductLoss)
    {
        mdProductLoss.setUpdateBy(getUsername());
        return toAjax(mdProductLossService.updateMdProductLoss(mdProductLoss));
    }

    /**
     * 删除产品loss配置
     */
    @PreAuthorize("@ss.hasPermi('md:loss:remove')")
    @Log(title = "产品loss配置", businessType = BusinessType.DELETE)
	@DeleteMapping("/{productLossIds}")
    public AjaxResult remove(@PathVariable Long[] productLossIds)
    {
        return toAjax(mdProductLossService.deleteMdProductLossByProductLossIds(productLossIds));
    }
}
