package com.ximai.mes.md.controller;

import java.util.List;
import javax.servlet.http.HttpServletResponse;

import com.ximai.mes.md.vo.MdProductFactoryVo;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.ximai.common.annotation.Log;
import com.ximai.common.core.controller.BaseController;
import com.ximai.common.core.domain.AjaxResult;
import com.ximai.common.enums.BusinessType;
import com.ximai.mes.md.domain.MdProductFactory;
import com.ximai.mes.md.service.IMdProductFactoryService;
import com.ximai.common.utils.poi.ExcelUtil;
import com.ximai.common.core.page.TableDataInfo;

/**
 * 产品工厂配置Controller
 *
 * @author yinjinlu
 * @date 2024-01-17
 */
@RestController
@RequestMapping("/md/factory")
public class MdProductFactoryController extends BaseController
{
    @Autowired
    private IMdProductFactoryService mdProductFactoryService;

    /**
     * 查询产品工厂配置列表
     */
    @PreAuthorize("@ss.hasPermi('md:factory:list')")
    @GetMapping("/list")
    public TableDataInfo list(MdProductFactory mdProductFactory)
    {
        startPage();
        List<MdProductFactoryVo> list = mdProductFactoryService.selectMdProductFactoryList(mdProductFactory);
        return getDataTable(list);
    }

    /**
     * 导出产品工厂配置列表
     */
    @PreAuthorize("@ss.hasPermi('md:factory:export')")
    @Log(title = "产品工厂配置", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, MdProductFactory mdProductFactory)
    {
        List<MdProductFactoryVo> list = mdProductFactoryService.selectMdProductFactoryList(mdProductFactory);
        ExcelUtil<MdProductFactoryVo> util = new ExcelUtil<MdProductFactoryVo>(MdProductFactoryVo.class);
        util.exportExcel(response, list, "产品工厂配置数据");
    }

    /**
     * 获取产品工厂配置详细信息
     */
    @PreAuthorize("@ss.hasPermi('md:factory:query')")
    @GetMapping(value = "/{productFactoryId}")
    public AjaxResult getInfo(@PathVariable("productFactoryId") Long productFactoryId)
    {
        return AjaxResult.success(mdProductFactoryService.selectMdProductFactoryByProductFactoryId(productFactoryId));
    }

    /**
     * 新增产品工厂配置
     */
    @PreAuthorize("@ss.hasPermi('md:factory:add')")
    @Log(title = "产品工厂配置", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody MdProductFactory mdProductFactory)
    {
        mdProductFactory.setCreateBy(getUsername());
        return toAjax(mdProductFactoryService.insertMdProductFactory(mdProductFactory));
    }

    /**
     * 修改产品工厂配置
     */
    @PreAuthorize("@ss.hasPermi('md:factory:edit')")
    @Log(title = "产品工厂配置", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody MdProductFactory mdProductFactory)
    {
        mdProductFactory.setUpdateBy(getUsername());
        return toAjax(mdProductFactoryService.updateMdProductFactory(mdProductFactory));
    }

    /**
     * 删除产品工厂配置
     */
    @PreAuthorize("@ss.hasPermi('md:factory:remove')")
    @Log(title = "产品工厂配置", businessType = BusinessType.DELETE)
	@DeleteMapping("/{productFactoryIds}")
    public AjaxResult remove(@PathVariable Long[] productFactoryIds)
    {
        return toAjax(mdProductFactoryService.deleteMdProductFactoryByProductFactoryIds(productFactoryIds));
    }
}
