package com.ximai.mes.md.controller;

import com.ximai.common.annotation.Log;
import com.ximai.common.core.controller.BaseController;
import com.ximai.common.core.domain.AjaxResult;
import com.ximai.common.core.page.TableDataInfo;
import com.ximai.common.enums.BusinessType;
import com.ximai.common.utils.poi.ExcelUtil;
import com.ximai.mes.md.domain.MdClientPaymentRelation;
import com.ximai.mes.md.service.IMdClientPaymentRelationService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 * 客户付款信息关联Controller
 *
 * @author yinjinlu
 * @date 2024-01-19
 */
@RestController
@RequestMapping("/md/clientPaymentRelation")
public class MdClientPaymentRelationController extends BaseController {
    @Autowired
    private IMdClientPaymentRelationService mdClientPaymentRelationService;

    /**
     * 查询客户付款信息关联列表
     */
//    @PreAuthorize("@ss.hasPermi('md:clientPaymentRelation:list')")
    @GetMapping("/list")
    public TableDataInfo list(MdClientPaymentRelation mdClientPaymentRelation) {
        startPage();
        List<MdClientPaymentRelation> list = mdClientPaymentRelationService.selectMdClientPaymentRelationList(mdClientPaymentRelation);
        return getDataTable(list);
    }

    /**
     * 导出客户付款信息关联列表
     */
//    @PreAuthorize("@ss.hasPermi('md:clientPaymentRelation:export')")
    @Log(title = "客户付款信息关联", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, MdClientPaymentRelation mdClientPaymentRelation) {
        List<MdClientPaymentRelation> list = mdClientPaymentRelationService.selectMdClientPaymentRelationList(mdClientPaymentRelation);
        ExcelUtil<MdClientPaymentRelation> util = new ExcelUtil<MdClientPaymentRelation>(MdClientPaymentRelation.class);
        util.exportExcel(response, list, "客户付款信息关联数据");
    }

    /**
     * 获取客户付款信息关联详细信息
     */
//    @PreAuthorize("@ss.hasPermi('md:clientPaymentRelation:query')")
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") String id) {
        return AjaxResult.success(mdClientPaymentRelationService.selectMdClientPaymentRelationById(id));
    }

    /**
     * 新增客户付款信息关联
     */
//    @PreAuthorize("@ss.hasPermi('md:clientPaymentRelation:add')")
    @Log(title = "客户付款信息关联", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody MdClientPaymentRelation mdClientPaymentRelation) {
        return toAjax(mdClientPaymentRelationService.insertMdClientPaymentRelation(mdClientPaymentRelation));
    }

    /**
     * 修改客户付款信息关联
     */
//    @PreAuthorize("@ss.hasPermi('md:clientPaymentRelation:edit')")
    @Log(title = "客户付款信息关联", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody MdClientPaymentRelation mdClientPaymentRelation) {
        return toAjax(mdClientPaymentRelationService.updateMdClientPaymentRelation(mdClientPaymentRelation));
    }

    /**
     * 删除客户付款信息关联
     */
//    @PreAuthorize("@ss.hasPermi('md:clientPaymentRelation:remove')")
    @Log(title = "客户付款信息关联", businessType = BusinessType.DELETE)
    @DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable String[] ids) {
        return toAjax(mdClientPaymentRelationService.deleteMdClientPaymentRelationByIds(ids));
    }
}
