package com.ximai.mes.md.controller;

import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;

import com.ximai.mes.md.vo.MdClientItemVo;
import lombok.AllArgsConstructor;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.*;
import com.ximai.common.annotation.Log;
import com.ximai.common.core.controller.BaseController;
import com.ximai.common.core.domain.AjaxResult;
import com.ximai.common.enums.BusinessType;
import com.ximai.mes.md.domain.MdClientItem;
import com.ximai.mes.md.service.IMdClientItemService;
import com.ximai.common.utils.poi.ExcelUtil;
import org.springframework.web.multipart.MultipartFile;

/**
 * 客户产品对照Controller
 *
 * @author generator
 * @date 2024-01-25
 */
@RestController
@AllArgsConstructor
@RequestMapping("/md/clientItem")
public class MdClientItemController extends BaseController{

    private final IMdClientItemService mdClientItemService;

    /**
     * 查询客户产品对照列表
     */
    @PreAuthorize("@ss.hasPermi('md:clientItem:list')")
    @PostMapping("/list")
    public AjaxResult list(@RequestBody Map<String, Object> params) {
        return AjaxResult.success(mdClientItemService.page(params));
    }
    /**
     * 导入产品对照组列表
     */
    @PreAuthorize("@ss.hasPermi('md:clientItem:import')")
    @Log(title = "客户产品对照", businessType = BusinessType.IMPORT)
    @PostMapping("/importData")
    public AjaxResult importData( String clientCode , MultipartFile file, boolean updateSupport) throws Exception
    {
        ExcelUtil<MdClientItem> util = new ExcelUtil<>(MdClientItem.class);
        List<MdClientItem> mdClientItemsList = util.importExcel(file.getInputStream());
        String operaName = getUsername();
        String message = mdClientItemService.importMdClientItem(mdClientItemsList, clientCode, updateSupport, operaName);
        return AjaxResult.success(message);
    }

    /**
     * 下载模板
     * @param response
     */
    @PostMapping("/importTemplate")
    public void importTemplate(HttpServletResponse response)
    {
        ExcelUtil<MdClientItemVo> util = new ExcelUtil<>(MdClientItemVo.class);
        util.importTemplateExcel(response, "产品对照组数据");
    }

    /**
     * 导出客户产品对照列表
     */
    @PreAuthorize("@ss.hasPermi('md:clientItem:export')")
    @Log(title = "客户产品对照", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, MdClientItem mdClientItem) {
        List<MdClientItem> list = mdClientItemService.selectList(mdClientItem);
        ExcelUtil<MdClientItem> util = new ExcelUtil<MdClientItem>(MdClientItem.class);
        util.exportExcel(response, list, "客户产品对照数据");
    }

    /**
     * 获取客户产品对照详细信息
     */
    @PreAuthorize("@ss.hasPermi('md:clientItem:query')")
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") String id) {
        return AjaxResult.success(mdClientItemService.selectById(id));
    }

    /**
     * 新增客户产品对照
     */
    @PreAuthorize("@ss.hasPermi('md:clientItem:add')")
    @Log(title = "客户产品对照", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody MdClientItem mdClientItem) {
        return mdClientItemService.insert(mdClientItem) ? AjaxResult.success() : AjaxResult.error();
    }

    /**
     * 修改客户产品对照
     */
    @PreAuthorize("@ss.hasPermi('md:clientItem:edit')")
    @Log(title = "客户产品对照", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody MdClientItem mdClientItem) {
        return mdClientItemService.updateById(mdClientItem) ? AjaxResult.success() : AjaxResult.error();
    }

    /**
     * 删除客户产品对照
     */
    @PreAuthorize("@ss.hasPermi('md:clientItem:remove')")
    @Log(title = "客户产品对照", businessType = BusinessType.DELETE)
	@DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable List<String> ids) {
        return mdClientItemService.deleteByIds(ids) ? AjaxResult.success() : AjaxResult.error();
    }
}
