package com.ximai.mes.md.controller;

import java.util.List;
import javax.servlet.http.HttpServletResponse;

import com.ximai.mes.md.domain.MdBrand;
import com.ximai.mes.md.service.IMdBrandService;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.ximai.common.annotation.Log;
import com.ximai.common.core.controller.BaseController;
import com.ximai.common.core.domain.AjaxResult;
import com.ximai.common.enums.BusinessType;
import com.ximai.mes.md.domain.MdBrandOrderQuantity;
import com.ximai.mes.md.service.IMdBrandOrderQuantityService;
import com.ximai.common.utils.poi.ExcelUtil;
import com.ximai.common.core.page.TableDataInfo;

/**
 * 【请填写功能名称】Controller
 *
 * @author yinjinlu
 * @date 2024-01-16
 */
@RestController
@RequestMapping("/md/quantity")
public class MdBrandOrderQuantityController extends BaseController
{
    @Autowired
    private IMdBrandOrderQuantityService mdBrandOrderQuantityService;

    @Autowired
    private IMdBrandService mdBrandService;

    /**
     * 查询【请填写功能名称】列表
     */
  //  @PreAuthorize("@ss.hasPermi('md:quantity:list')")
    @GetMapping("/list")
    public TableDataInfo list(MdBrandOrderQuantity mdBrandOrderQuantity)
    {
        startPage();
        List<MdBrandOrderQuantity> list = mdBrandOrderQuantityService.selectMdBrandOrderQuantityList(mdBrandOrderQuantity);
        return getDataTable(list);
    }

    /**
     * 导出【请填写功能名称】列表
     */
   // @PreAuthorize("@ss.hasPermi('md:quantity:export')")
    @Log(title = "【请填写功能名称】", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, MdBrandOrderQuantity mdBrandOrderQuantity)
    {
        List<MdBrandOrderQuantity> list = mdBrandOrderQuantityService.selectMdBrandOrderQuantityList(mdBrandOrderQuantity);
        ExcelUtil<MdBrandOrderQuantity> util = new ExcelUtil<MdBrandOrderQuantity>(MdBrandOrderQuantity.class);
        util.exportExcel(response, list, "【请填写功能名称】数据");
    }

    /**
     * 获取【请填写功能名称】详细信息
     */
   // @PreAuthorize("@ss.hasPermi('md:quantity:query')")
    @GetMapping(value = "/{brandOrderQuantityId}")
    public AjaxResult getInfo(@PathVariable("brandOrderQuantityId") Long brandOrderQuantityId)
    {
        return AjaxResult.success(mdBrandOrderQuantityService.selectMdBrandOrderQuantityByBrandOrderQuantityId(brandOrderQuantityId));
    }

    /**
     * 新增【请填写功能名称】
     */
   // @PreAuthorize("@ss.hasPermi('md:quantity:add')")
    @Log(title = "【请填写功能名称】", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody MdBrandOrderQuantity mdBrandOrderQuantity)
    {
        return toAjax(mdBrandOrderQuantityService.insertMdBrandOrderQuantity(mdBrandOrderQuantity));
    }

    /**
     * 修改【请填写功能名称】
     */
   // @PreAuthorize("@ss.hasPermi('md:quantity:edit')")
    @Log(title = "【请填写功能名称】", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody MdBrandOrderQuantity mdBrandOrderQuantity)
    {
        return toAjax(mdBrandOrderQuantityService.updateMdBrandOrderQuantity(mdBrandOrderQuantity));
    }

    /**
     * 删除【请填写功能名称】
     */
    //
    // @PreAuthorize("@ss.hasPermi('md:quantity:remove')")
    @Log(title = "【请填写功能名称】", businessType = BusinessType.DELETE)
	@DeleteMapping("/{brandOrderQuantityIds}")
    public AjaxResult remove(@PathVariable Long[] brandOrderQuantityIds)
    {
        return toAjax(mdBrandOrderQuantityService.deleteMdBrandOrderQuantityByBrandOrderQuantityIds(brandOrderQuantityIds));
    }
    /**
     * 查询品牌列表
     */
    @PreAuthorize("@ss.hasPermi('md:contact:listBrand')")
    @GetMapping("/listBrand")
    public AjaxResult list()
    {
        MdBrand mdBrand = new MdBrand();
        mdBrand.setEnableFlag("Y");
        List<MdBrand> list = mdBrandService.selectMdBrandList(mdBrand);
        return AjaxResult.success(list);
    }

}
