package com.ximai.mes.md.controller;

import java.util.List;
import javax.servlet.http.HttpServletResponse;

import cn.hutool.core.collection.CollectionUtil;
import com.ximai.common.utils.data.StringUtils;
import com.ximai.mes.md.domain.MdBrand;
import com.ximai.mes.md.service.IMdBrandService;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.ximai.common.annotation.Log;
import com.ximai.common.core.controller.BaseController;
import com.ximai.common.core.domain.AjaxResult;
import com.ximai.common.enums.BusinessType;
import com.ximai.mes.md.domain.MdBrandContact;
import com.ximai.mes.md.service.IMdBrandContactService;
import com.ximai.common.utils.poi.ExcelUtil;
import com.ximai.common.core.page.TableDataInfo;

/**
 * 品牌联系人Controller
 *
 * @author yinjinlu
 * @date 2024-01-16
 */
@RestController
@RequestMapping("/md/contact")
public class MdBrandContactController extends BaseController
{
    @Autowired
    private IMdBrandContactService mdBrandContactService;

    @Autowired
    private IMdBrandService mdBrandService;

    /**
     * 查询品牌联系人列表
     */
    @PreAuthorize("@ss.hasPermi('mes:md:contact:list')")
    @GetMapping("/list")
    public TableDataInfo list(MdBrandContact mdBrandContact)
    {
        startPage();
        List<MdBrandContact> list = mdBrandContactService.selectMdBrandContactList(mdBrandContact);
        return getDataTable(list);
    }

    /**
     * 导出品牌联系人列表
     */
    @PreAuthorize("@ss.hasPermi('mes:md:contact:export')")
    @Log(title = "品牌联系人", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, MdBrandContact mdBrandContact)
    {
        List<MdBrandContact> list = mdBrandContactService.selectMdBrandContactList(mdBrandContact);
        if (CollectionUtil.isNotEmpty(list)){
            list.stream().filter(e-> StringUtils.isNotEmpty(e.getEnableFlag())).forEach(e->
                    e.setEnableFlag("Y".equals(e.getEnableFlag())?"是":"否")
            );
        }
        ExcelUtil<MdBrandContact> util = new ExcelUtil<MdBrandContact>(MdBrandContact.class);
        util.exportExcel(response, list, "品牌联系人数据");
    }

    /**
     * 获取品牌联系人详细信息
     */
    @PreAuthorize("@ss.hasPermi('mes:md:contact:query')")
    @GetMapping(value = "/{brandContactId}")
    public AjaxResult getInfo(@PathVariable("brandContactId") Long brandContactId)
    {
        return AjaxResult.success(mdBrandContactService.selectMdBrandContactByBrandContactId(brandContactId));
    }

    /**
     * 新增品牌联系人
     */
    @PreAuthorize("@ss.hasPermi('mes:md:contact:add')")
    @Log(title = "品牌联系人", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody MdBrandContact mdBrandContact)
    {
        return toAjax(mdBrandContactService.insertMdBrandContact(mdBrandContact));
    }

    /**
     * 修改品牌联系人
     */
    @PreAuthorize("@ss.hasPermi('mes:md:contact:edit')")
    @Log(title = "品牌联系人", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody MdBrandContact mdBrandContact)
    {
        return toAjax(mdBrandContactService.updateMdBrandContact(mdBrandContact));
    }

    /**
     * 删除品牌联系人
     */
    @PreAuthorize("@ss.hasPermi('mes:md:contact:remove')")
    @Log(title = "品牌联系人", businessType = BusinessType.DELETE)
    @DeleteMapping("/{brandContactIds}")
    public AjaxResult remove(@PathVariable Long[] brandContactIds)
    {
        return toAjax(mdBrandContactService.deleteMdBrandContactByBrandContactIds(brandContactIds));
    }

    /**
     * 查询品牌列表
     */
    @PreAuthorize("@ss.hasPermi('mes:md:contact:listBrand')")
    @GetMapping("/listBrand")
    public AjaxResult list()
    {
        MdBrand mdBrand = new MdBrand();
        mdBrand.setEnableFlag("Y");
        List<MdBrand> list = mdBrandService.selectMdBrandList(mdBrand);
        return AjaxResult.success(list);
    }
}
