package com.ximai.mes.face.sap.execute;

import com.alibaba.fastjson.JSONObject;
import com.ximai.mes.pro.domain.sap.SAPQcIqcRecpt;
import com.ximai.mes.qc.domain.QcIqc;
import lombok.Builder;
import lombok.extern.slf4j.Slf4j;

import java.util.Collections;

@Builder
@Slf4j
public class SapServiceIqcRecpt implements SapServiceClient {

    QcIqc qcIqc;

    @Override
    public void execute() {

        SAPQcIqcRecpt sapQcIqc = qcIqc.deepCopyObj(SAPQcIqcRecpt.class);
//        if (Objects.equals(qcIqc.getCheckResult(), "REJECT")) {
//        } else {
//        }

        String json = JSONObject.toJSONString(Collections.singletonList(sapQcIqc));
        log.info("------------------------------------------------------------------->>>> 请求结果:  " + json);
        String s = getSapService().uploadIqcResult(json);
        log.info("------------------------------------------------------------------->>>> 返回结果:  " + s);

    }
}
