package com.ximai.mes.face.sap.execute;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ximai.common.utils.data.DataUtil;
import com.ximai.common.utils.data.ExceptionUtil;
import com.ximai.mes.constant.WorkorderConst;
import com.ximai.mes.pro.domain.ProFeedback;
import com.ximai.mes.pro.domain.proWorkOrder.ProWorkorder;
import com.ximai.mes.pro.domain.sap.SAPDtoFeedback;
import com.ximai.mes.pro.mapper.proWorkOrder.ProWorkorderMapper;
import lombok.Builder;
import lombok.extern.slf4j.Slf4j;

import java.util.Collections;
import java.util.List;
import java.util.Objects;

@Slf4j
@Builder
public class SapServiceFeedback implements SapServiceClient {
    private SAPDtoFeedback sapDtoFeedback;
    private ProFeedback feedback;
    private String actionMsg;
    private ProWorkorderMapper proWorkorderMapper;

    @Override
    public void execute() {
        ProWorkorder proWorkorder = proWorkorderMapper.selectListByQw(new QueryWrapper<ProWorkorder>().eq("workorder_id", feedback.getWorkorderId())).get(0);
        if (Objects.equals(proWorkorder.getWorkorderType(), WorkorderConst.WORK_ORDER_COMPLEMENTS_TYPE)) {
            if (sapDtoFeedback.getWorkorderCode().contains("-")) {
                sapDtoFeedback.setWorkorderCode(sapDtoFeedback.getWorkorderCode().split("-")[0]);
            }
        }

        String json = JSON.toJSONString(Collections.singletonList(sapDtoFeedback));
        log.info("------------------------------------------------------------------->>>> sap操作:  " + actionMsg);
        log.info("------------------------------------------------------------------->>>> 请求参数:  " + json);
        String result = getSapService().uploadFeedbackData(json);
        log.info("------------------------------------------------------------------->>>> 返回结果:  " + result);
        feedback.setSapRequestParam(json);
        feedback.setSapResponse(result);
        List<JSONObject> jsonObjects = null;
        // String abc = "[{\"TYPE\":\"E\",\"ID\":\"\",\"NUMBER\":\"000\",\"MESSAGE\":\"订单报工成功\",\"LOG_NO\":\"\",\"LOG_MSG_NO\":\"000000\",\"MESSAGE_V1\":\"0000000037\",\"MESSAGE_V2\":\"00000002\",\"MESSAGE_V3\":\"\",\"MESSAGE_V4\":\"\",\"PARAMETER\":\"\",\"ROW\":0 ,\"FIELD\":\"\",\"SYSTEM\":\"\"}]";
        //
        try {
            jsonObjects = JSON.parseArray(result, JSONObject.class);
            JSONObject jsonObject = jsonObjects.get(0);
            Object type = jsonObject.get("TYPE");
            Object msg = jsonObject.get("MESSAGE");

            ExceptionUtil.checkTrueThrowException(type == null, "sap报工失败!");
            ExceptionUtil.checkTrueThrowException(!"s".equalsIgnoreCase(type.toString()), msg.toString());


            String sapFeedbackCode = DataUtil.getNormalData(jsonObject.get("MESSAGE_V1"), String.class);
            String sapFeedbackItemCode = DataUtil.getNormalData(jsonObject.get("MESSAGE_V2"), String.class);
            feedback.setSapFeedbackCode(sapFeedbackCode);
            feedback.setSapFeedbackItemCode(sapFeedbackItemCode);
        } catch (Exception e) {
            ExceptionUtil.throwExcetion(e.getMessage());
        }

    }
}
