package com.ximai.mes.face.sap.execute;

import com.alibaba.fastjson.JSONObject;
import com.ximai.mes.pro.domain.ProFeedback;
import com.ximai.mes.pro.domain.sap.SAPDtoTaskAssistProcess;
import com.ximai.mes.pro.domain.task.ProTaskAssistProcess;
import lombok.Builder;
import lombok.extern.slf4j.Slf4j;

import java.util.Collections;

@Builder
@Slf4j
public class SapServiceAssistProcess implements SapServiceClient {
    ProFeedback feedback;
    ProTaskAssistProcess proTaskAssistProcess;

    @Override
    public void execute() {
        SAPDtoTaskAssistProcess sapTaskAssistProcess = new SAPDtoTaskAssistProcess();
        sapTaskAssistProcess.setAssistProcessCode(proTaskAssistProcess.getAssistProcessCode());
        sapTaskAssistProcess.setAssistProcessItemCode(proTaskAssistProcess.getAssistProcessItemCode());
        sapTaskAssistProcess.setCloseType(proTaskAssistProcess.getCloseType());
        sapTaskAssistProcess.setUnit(proTaskAssistProcess.getUnit());
        sapTaskAssistProcess.setQuantity(feedback.getQuantityFeedback().longValue());
        String json = JSONObject.toJSONString(Collections.singletonList(sapTaskAssistProcess));
        log.info("------------------------------------------------------------------->>>> 请求结果:  " + json);
        String s = getSapService().uploadAssistProcessTaskData(json);
        log.info("------------------------------------------------------------------->>>> 返回结果:  " + s);

    }
}
