package com.ximai.mes.face.sap;

import com.ximai.mes.config.FooConfiguration;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;

/**
 * @Auther: xin.lu
 * @Date: 2024/01/23/11:30
 * @Description:
 */
@FeignClient(value = "sap-service",
        url = "${remote.sap.url}",
        path = "${remote.sap.path}", configuration = FooConfiguration.class,
        contextId = "SapServiceClient"
)
public interface SapService {

    /**
     * 根据字典编码（字段名）查询数据字典
     *
     * @param param
     * @return
     */
    @PostMapping("ep_dict?sap-client=${remote.sap.sapclient}")
    String getSapDictionaryList(String param);

    /**
     * 上传客户主数据
     */
    @PostMapping("cud_custom/customer?sap-client=${remote.sap.sapclient}")
    String uploadCustomerData(String param);

    /*
     报工外协上传数量接口
     */
    @PostMapping("mes_post_po?sap-client=${remote.sap.sapclient}")
    String uploadAssistProcessTaskData(String param);

    /*
 上报iqc检测结果
 */
    @PostMapping("mes_post_po?sap-client=${remote.sap.sapclient}")
    String uploadIqcResult(String param);

    /*
     更新工单状态
     */
    @PostMapping("mes_order_zt/order_zt?sap-client=${remote.sap.sapclient}")
    String updateWorkorderStatus(String param);

    /*
     上传报工数据
     */
    @PostMapping("mes_order_tt/order_tt?sap-client=${remote.sap.sapclient}")
    String uploadFeedbackData(String param);

    /*
      上传收货  uploadReceipts
      */
//    @PostMapping("sap/bc/erp_ep/mes_post_po?sap-client=${remote.sap.sapclient}")
//    String uploadReceipts(String param);

    /**
     * 同步物料产品信息
     *
     * @param s1
     * @return
     */
    @PostMapping("bd_mastdata/material02?sap-client=${remote.sap.sapclient}")
    String syncMdItemData(String s1);

    /**
     * 同步销售订单数据
     */
    @PostMapping("cud_salses/salses_data?sap-client=${remote.sap.sapclient}")
    String syncSaleOrder(String json);

    /**
     * 同步销售订单数据
     */
    @PostMapping("post_delv?sap-client=${remote.sap.sapclient}")
    String syncPostDelv(String json);

    /**
     * 采购入库扫描
     */
    @PostMapping("get_mm_plnr/plnr?sap-client=${remote.sap.sapclient}")
    String getMmPlnrPlnr(String json);

}
