package com.ximai.mes.face.ep;

import com.ximai.mes.config.EPConfiguration;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;

/**
 * @Auther: xin.lu
 * @Date: 2024/01/23/11:30
 * @Description:
 */
@FeignClient(value = "ep-service",
        url = "${remote.ep.url}",
        path = "${remote.ep.path}", configuration = EPConfiguration.class,
        contextId = "EpServiceClient"
)
public interface EpService {
    //http://192.168.3.91:12000//api/itemSerial/updCurrent
    //密码
    //用户名

    /**
     * 查询ep流水
     *
     * @param param
     * @return
     */
    @PostMapping("/get?ep-client=${remote.ep.epclient}")
    String getEpItemSerial(String param);

    /**
     * 修改ep流水
     *
     * @param param
     * @return
     */
    @PostMapping("/updCurrent?ep-client=${remote.ep.epclient}")
    String updateEpItemSerial(String param);

}
