package com.ximai.mes.dv.controller;

import java.util.List;
import javax.servlet.http.HttpServletResponse;

import com.ximai.mes.dv.domain.devBrandQuotation.DvBrandQuotation;
import com.ximai.mes.dv.domain.vo.DvBrandQuotationVo;
import com.ximai.mes.dv.service.devBrandQuotation.IDvBrandQuotationService;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.ximai.common.annotation.Log;
import com.ximai.common.core.controller.BaseController;
import com.ximai.common.core.domain.AjaxResult;
import com.ximai.common.enums.BusinessType;

import com.ximai.common.utils.poi.ExcelUtil;
import com.ximai.common.core.page.TableDataInfo;

/**
 * 品牌报价Controller
 *
 * @author yinjinlu
 * @date 2024-01-25
 */
@RestController
@RequestMapping("/dv/brandQuotation")
public class DvBrandQuotationController extends BaseController
{
    @Autowired
    private IDvBrandQuotationService devBrandQuotationService;

    /**
     * 查询品牌报价列表
     */
    @PreAuthorize("@ss.hasPermi('dv:brandQuotation:list')")
    @GetMapping("/list")
    public TableDataInfo list(DvBrandQuotation devBrandQuotation)
    {
        startPage();
        List<DvBrandQuotation> list = devBrandQuotationService.selectDevBrandQuotationList(devBrandQuotation);
        return getDataTable(list);
    }

    /**
     * 导出品牌报价列表
     */
    @PreAuthorize("@ss.hasPermi('dv:brandQuotation:export')")
    @Log(title = "【请填写功能名称】", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, DvBrandQuotation devBrandQuotation)
    {
        List<DvBrandQuotation> list = devBrandQuotationService.selectDevBrandQuotationList(devBrandQuotation);
        ExcelUtil<DvBrandQuotation> util = new ExcelUtil<DvBrandQuotation>(DvBrandQuotation.class);
        util.exportExcel(response, list, "【请填写功能名称】数据");
    }

    /**
     * 获取品牌报价详细信息
     */
    @PreAuthorize("@ss.hasPermi('dv:brandQuotation:query')")
    @GetMapping(value = "/{brandQuotationId}")
    public AjaxResult getInfo(@PathVariable("brandQuotationId") Long brandQuotationId)
    {
        return AjaxResult.success(devBrandQuotationService.selectDevBrandQuotationByBrandQuotationId(brandQuotationId));
    }

    /**
     * 新增品牌报价
     */
    @PreAuthorize("@ss.hasPermi('dv:brandQuotation:add')")
    @Log(title = "【请填写功能名称】", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody DvBrandQuotationVo dvBrandQuotationVo)
    {
        return toAjax(devBrandQuotationService.insertDevBrandQuotation(dvBrandQuotationVo));
    }

    /**
     * 修改品牌报价
     */
    @PreAuthorize("@ss.hasPermi('dv:brandQuotation:edit')")
    @Log(title = "【请填写功能名称】", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody DvBrandQuotationVo devBrandQuotationVo)
    {
        return toAjax(devBrandQuotationService.updateDevBrandQuotation(devBrandQuotationVo));
    }

    /**
     * 删除品牌报价功能
     */
    @PreAuthorize("@ss.hasPermi('dv:brandQuotation:remove')")
    @Log(title = "【请填写功能名称】", businessType = BusinessType.DELETE)
	@DeleteMapping("/{brandQuotationIds}")
    public AjaxResult remove(@PathVariable Long[] brandQuotationIds)
    {
        return toAjax(devBrandQuotationService.deleteDevBrandQuotationByBrandQuotationIds(brandQuotationIds));
    }
}
