package com.ximai.mes.dv.controller;

import com.ximai.common.annotation.Log;
import com.ximai.common.core.controller.BaseController;
import com.ximai.common.core.domain.AjaxResult;
import com.ximai.common.core.page.TableDataInfo;
import com.ximai.common.enums.BusinessType;
import com.ximai.common.utils.poi.ExcelUtil;
import com.ximai.mes.dv.domain.devBrandQuotation.DvBrandQuotationBom;
import com.ximai.mes.dv.service.devBrandQuotation.IDvBrandQuotationBomService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 * 【请填写功能名称】Controller
 *
 * @author yinjinlu
 * @date 2024-01-25
 */
@RestController
@RequestMapping("/dv/bom")
public class DvBrandQuotationBomController extends BaseController {
    @Autowired
    private IDvBrandQuotationBomService devBrandQuotationBomService;

    /**
     * 查询【请填写功能名称】列表
     */
    @PreAuthorize("@ss.hasPermi('md:bom:list')")
    @GetMapping("/list")
    public TableDataInfo list(DvBrandQuotationBom devBrandQuotationBom) {
        startPage();
        List<DvBrandQuotationBom> list = devBrandQuotationBomService.selectDevBrandQuotationBomList(devBrandQuotationBom);
        return getDataTable(list);
    }

    /**
     * 导出【请填写功能名称】列表
     */
    @PreAuthorize("@ss.hasPermi('md:bom:export')")
    @Log(title = "【请填写功能名称】", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, DvBrandQuotationBom devBrandQuotationBom) {
        List<DvBrandQuotationBom> list = devBrandQuotationBomService.selectDevBrandQuotationBomList(devBrandQuotationBom);
        ExcelUtil<DvBrandQuotationBom> util = new ExcelUtil<DvBrandQuotationBom>(DvBrandQuotationBom.class);
        util.exportExcel(response, list, "【请填写功能名称】数据");
    }

    /**
     * 获取【请填写功能名称】详细信息
     */
    @PreAuthorize("@ss.hasPermi('md:bom:query')")
    @GetMapping(value = "/{bomItemId}")
    public AjaxResult getInfo(@PathVariable("bomItemId") Long bomItemId) {
        return AjaxResult.success(devBrandQuotationBomService.selectDevBrandQuotationBomByBomItemId(bomItemId));
    }

    /**
     * 新增【请填写功能名称】
     */
    @PreAuthorize("@ss.hasPermi('md:bom:add')")
    @Log(title = "【请填写功能名称】", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody DvBrandQuotationBom devBrandQuotationBom) {
        return toAjax(devBrandQuotationBomService.insertDevBrandQuotationBom(devBrandQuotationBom));
    }

    /**
     * 修改【请填写功能名称】
     */
    @PreAuthorize("@ss.hasPermi('md:bom:edit')")
    @Log(title = "【请填写功能名称】", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody DvBrandQuotationBom devBrandQuotationBom) {
        return toAjax(devBrandQuotationBomService.updateDevBrandQuotationBom(devBrandQuotationBom));
    }

    /**
     * 删除【请填写功能名称】
     */
    @PreAuthorize("@ss.hasPermi('md:bom:remove')")
    @Log(title = "【请填写功能名称】", businessType = BusinessType.DELETE)
    @DeleteMapping("/{bomItemIds}")
    public AjaxResult remove(@PathVariable Long[] bomItemIds) {
        return toAjax(devBrandQuotationBomService.deleteDevBrandQuotationBomByBomItemIds(bomItemIds));
    }
}
