package com.ximai.mes.dv.controller;

import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.ximai.common.annotation.Log;
import com.ximai.common.core.controller.BaseController;
import com.ximai.common.core.domain.AjaxResult;
import com.ximai.common.enums.BusinessType;
import com.ximai.mes.dv.domain.devBrandQuotation.DevBrandQuotationProcessQcindex;
import com.ximai.mes.dv.service.devBrandQuotation.IDevBrandQuotationProcessQcindexService;
import com.ximai.common.utils.poi.ExcelUtil;
import com.ximai.common.core.page.TableDataInfo;

/**
 * 品牌报价工序检验项Controller
 *
 * @author generator
 * @date 2024-01-28
 */
@RestController
@RequestMapping("/dv/brandQuotationProcessQcindex")
public class DevBrandQuotationProcessQcindexController extends BaseController
{
    @Autowired
    private IDevBrandQuotationProcessQcindexService devBrandQuotationProcessQcindexService;

    /**
     * 查询品牌报价工序检验项列表
     */
    @PreAuthorize("@ss.hasPermi('dv:brandQuotationProcessQcindex:list')")
    @GetMapping("/list")
    public TableDataInfo list(DevBrandQuotationProcessQcindex devBrandQuotationProcessQcindex)
    {
        startPage();
        List<DevBrandQuotationProcessQcindex> list = devBrandQuotationProcessQcindexService.selectDevBrandQuotationProcessQcindexList(devBrandQuotationProcessQcindex);
        return getDataTable(list);
    }

    /**
     * 导出品牌报价工序检验项列表
     */
    @PreAuthorize("@ss.hasPermi('dv:brandQuotationProcessQcindex:export')")
    @Log(title = "品牌报价工序检验项", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, DevBrandQuotationProcessQcindex devBrandQuotationProcessQcindex)
    {
        List<DevBrandQuotationProcessQcindex> list = devBrandQuotationProcessQcindexService.selectDevBrandQuotationProcessQcindexList(devBrandQuotationProcessQcindex);
        ExcelUtil<DevBrandQuotationProcessQcindex> util = new ExcelUtil<DevBrandQuotationProcessQcindex>(DevBrandQuotationProcessQcindex.class);
        util.exportExcel(response, list, "品牌报价工序检验项数据");
    }

    /**
     * 获取品牌报价工序检验项详细信息
     */
    @PreAuthorize("@ss.hasPermi('dv:brandQuotationProcessQcindex:query')")
    @GetMapping(value = "/{brandQuotationProcessQcindexId}")
    public AjaxResult getInfo(@PathVariable("brandQuotationProcessQcindexId") Long brandQuotationProcessQcindexId)
    {
        return AjaxResult.success(devBrandQuotationProcessQcindexService.selectDevBrandQuotationProcessQcindexByBrandQuotationProcessQcindexId(brandQuotationProcessQcindexId));
    }

    /**
     * 新增品牌报价工序检验项
     */
    @PreAuthorize("@ss.hasPermi('dv:brandQuotationProcessQcindex:add')")
    @Log(title = "品牌报价工序检验项", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody DevBrandQuotationProcessQcindex devBrandQuotationProcessQcindex)
    {
        return toAjax(devBrandQuotationProcessQcindexService.insertDevBrandQuotationProcessQcindex(devBrandQuotationProcessQcindex));
    }

    /**
     * 修改品牌报价工序检验项
     */
    @PreAuthorize("@ss.hasPermi('dv:brandQuotationProcessQcindex:edit')")
    @Log(title = "品牌报价工序检验项", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody DevBrandQuotationProcessQcindex devBrandQuotationProcessQcindex)
    {
        return toAjax(devBrandQuotationProcessQcindexService.updateDevBrandQuotationProcessQcindex(devBrandQuotationProcessQcindex));
    }

    /**
     * 删除品牌报价工序检验项
     */
    @PreAuthorize("@ss.hasPermi('dv:brandQuotationProcessQcindex:remove')")
    @Log(title = "品牌报价工序检验项", businessType = BusinessType.DELETE)
	@DeleteMapping("/{brandQuotationProcessQcindexIds}")
    public AjaxResult remove(@PathVariable Long[] brandQuotationProcessQcindexIds)
    {
        return toAjax(devBrandQuotationProcessQcindexService.deleteDevBrandQuotationProcessQcindexByBrandQuotationProcessQcindexIds(brandQuotationProcessQcindexIds));
    }
}
