package com.ximai.mes.constant;

/**
 * 任务单状态
 *
 * @ Author: chicheng.li
 * @ Date  : 2024/2/4
 */
public enum TmToolMachineCheckEnum {


    //刀模版记录未被创建
    ERROR_01(1, "刀模版具并未全部上机"),
    ERROR_04(4, "刀模版具并未全部上机"),
    ERROR_02(2, "刀模板记录未绑定刀具"),
    ERROR_05(5, "已绑定数刀模板记录不够小于必须需要的刀具"),

    NOMAL_00(0, "刀模板检测通过"),
    ERROR_06(6, "工序任务无刀模版具需要创建");

    private final Integer status;
    private final String msg;

    TmToolMachineCheckEnum(Integer status, String msg) {
        this.status = status;
        this.msg = msg;
    }

    public Integer getStatus() {
        return status;
    }

    public String getMsg() {
        return msg;
    }

    public static String get(Integer type) {
        for (TmToolMachineCheckEnum temp : TmToolMachineCheckEnum.values()) {
            if (temp.getStatus().equals(type)) {
                return temp.getMsg();
            }
        }
//        return  null
        return TmToolMachineCheckEnum.ERROR_04.getMsg();
//        throw new RuntimeException("异常上机类型");
    }
}
