package com.ximai.mes.config;

import com.ximai.system.service.ISysConfigService;
import feign.RequestInterceptor;
import feign.RequestTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;

import java.util.Base64;

/**
 * Feign调用的时候添加请求头
 */
@Configuration
public class FeignConfiguration implements RequestInterceptor {
    @Autowired
    private ISysConfigService configService;

    @Override
    public void apply(RequestTemplate requestTemplate) {
        //String url = configService.selectConfigByKey("sap.url");
        //requestTemplate.uri(url,true).uri("sap/bc/erp_ep/");
        String userName = configService.selectConfigByKey("sap.username");
        String passWord = configService.selectConfigByKey("sap.password");
        requestTemplate.header("Content-type", "application/json;charset=utf-8");
        String usernameAndPassword = userName + ":" + passWord;
        requestTemplate.header("Authorization", "Basic " + Base64.getEncoder().encodeToString(usernameAndPassword.getBytes()));
    }
}
