package com.ximai.mes.cal.service;

import com.ximai.mes.cal.domain.CalWorkunit;
import com.ximai.mes.md.domain.MdWorkunit;

import java.util.List;

/**
 * 计划工作单元Service接口
 *
 * @author generator
 * @date 2024-03-14
 */
public interface ICalWorkunitService {
    /**
     * 查询计划工作单元
     *
     * @param id 计划工作单元主键
     * @return 计划工作单元
     */
    CalWorkunit selectCalWorkunitById(Long id);

    /**
     * 查询计划工作单元列表
     *
     * @param calWorkunit 计划工作单元
     * @return 计划工作单元集合
     */
    List<CalWorkunit> selectCalWorkunitList(CalWorkunit calWorkunit);

    /**
     * 新增计划工作单元
     *
     * @param calWorkunit 计划工作单元
     * @return 结果
     */
    int insertCalWorkunit(CalWorkunit calWorkunit);

    /**
     * 修改计划工作单元
     *
     * @param calWorkunit 计划工作单元
     * @return 结果
     */
    int updateCalWorkunit(CalWorkunit calWorkunit);

    /**
     * 批量删除计划工作单元
     *
     * @param ids 需要删除的计划工作单元主键集合
     * @return 结果
     */
    int deleteCalWorkunitByIds(Long[] ids);

    /**
     * 删除计划工作单元信息
     *
     * @param id 计划工作单元主键
     * @return 结果
     */
    int deleteCalWorkunitById(Long id);

    List<MdWorkunit> selectUnSelectList(CalWorkunit calWorkunit);

    List<Object> treeMenu();


    void deleteCalWorkunitByPlanCode(String planCode);
}
