package com.ximai.mes.cal.controller;

import com.ximai.common.annotation.Log;
import com.ximai.common.core.controller.BaseController;
import com.ximai.common.core.domain.AjaxResult;
import com.ximai.common.core.page.TableDataInfo;
import com.ximai.common.enums.BusinessType;
import com.ximai.common.utils.poi.ExcelUtil;
import com.ximai.mes.cal.domain.CalWorkunit;
import com.ximai.mes.cal.service.ICalWorkunitService;
import com.ximai.mes.md.domain.MdWorkunit;
import com.ximai.mes.md.service.IMdWorkunitService;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/**
 * 计划工作单元Controller
 *
 * @author generator
 * @date 2024-03-14
 */
@RestController
@RequestMapping("/md/cal/workunit")
public class CalWorkunitController extends BaseController {

    @Autowired
    private ICalWorkunitService calWorkunitService;

    @Autowired
    private IMdWorkunitService mdWorkunitService;

    /**
     * 查询计划工作单元列表
     */
    @PreAuthorize("@ss.hasPermi('md:workunit:list')")
    @GetMapping("/list")
    public TableDataInfo list(CalWorkunit calWorkunit) {
        startPage();
        List<CalWorkunit> list = calWorkunitService.selectCalWorkunitList(calWorkunit);
        return getDataTable(list);
    }

    /**
     * 查询计划工作单元列表
     */
//    @PreAuthorize("@ss.hasPermi('md:workunit:list')")
    @GetMapping("/unSelectList")
    public TableDataInfo unSelectList(CalWorkunit calWorkunit) {
        startPage();
        List<MdWorkunit> list = calWorkunitService.selectUnSelectList(calWorkunit);
        return getDataTable(list);
    }

    @GetMapping("/calWorkunitList")
    public AjaxResult calWorkunitList() {
        List<CalWorkunit> list = calWorkunitService.selectCalWorkunitList(new CalWorkunit());
        Set<String> set = new HashSet<>();
        for (CalWorkunit workunit : list) {
            if (workunit.getWorkunitName() != null && !"".equals(workunit.getWorkunitName())) {
                set.add(workunit.getWorkunitName());
            }
        }
        return AjaxResult.success(set);
    }

    /**
     * 查询计划工作单元列表
     */
    @GetMapping("/treeMenu")
    public AjaxResult treeMenu() {
        return AjaxResult.success(calWorkunitService.treeMenu());
    }

    /**
     * 导出计划工作单元列表
     */
    @PreAuthorize("@ss.hasPermi('md:workunit:export')")
    @Log(title = "计划工作单元", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, CalWorkunit calWorkunit) {
        List<CalWorkunit> list = calWorkunitService.selectCalWorkunitList(calWorkunit);
        ExcelUtil<CalWorkunit> util = new ExcelUtil<CalWorkunit>(CalWorkunit.class);
        util.exportExcel(response, list, "计划工作单元数据");
    }

    /**
     * 获取计划工作单元详细信息
     */
    @PreAuthorize("@ss.hasPermi('md:workunit:query')")
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id) {
        return AjaxResult.success(calWorkunitService.selectCalWorkunitById(id));
    }

    /**
     * 新增计划工作单元
     */
    @ApiOperation("计划工作单元新增")
    @PreAuthorize("@ss.hasPermi('md:workunit:add')")
    @Log(title = "计划工作单元", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody CalWorkunit calWorkunit) {
        return toAjax(calWorkunitService.insertCalWorkunit(calWorkunit));
    }


    /**
     * 新增计划工作单元
     */
    @ApiOperation("计划工作单元批量新增")
    @PreAuthorize("@ss.hasPermi('md:workunit:add')")
    @Log(title = "计划工作单元批量新增", businessType = BusinessType.INSERT)
    @PostMapping(value = "/addList")
    public AjaxResult addList(@RequestBody List<CalWorkunit> calWorkunits) {
        for (CalWorkunit calWorkunit : calWorkunits) {
            calWorkunitService.insertCalWorkunit(calWorkunit);
        }
        return AjaxResult.success();
    }

    /**
     * 修改计划工作单元
     */
    @PreAuthorize("@ss.hasPermi('md:workunit:edit')")
    @Log(title = "计划工作单元", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody CalWorkunit calWorkunit) {
        return toAjax(calWorkunitService.updateCalWorkunit(calWorkunit));
    }

    /**
     * 删除计划工作单元
     */
    @ApiOperation("计划工作单元删除")
    @PreAuthorize("@ss.hasPermi('md:workunit:remove')")
    @Log(title = "计划工作单元删除", businessType = BusinessType.DELETE)
    @DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable String ids) {
        if (ids == null || "".equals(ids)) {
            throw new RuntimeException("计划工作单元删除条件为空");
        }
        List<Long> condition = new ArrayList<>();
        if (!ids.contains(",")) {
            String[] split = ids.split(",");
            for (String s : split) {
                condition.add(Long.parseLong(s));
            }
        }
        return toAjax(calWorkunitService.deleteCalWorkunitByIds(condition.toArray(new Long[0])));
    }


}
