package com.ximai.common.core.domain;

import com.baomidou.mybatisplus.annotation.TableField;
import com.ximai.common.utils.SecurityUtils;
import com.ximai.common.utils.bean.BeanUtils;
import com.ximai.common.utils.data.DataUtil;
import com.ximai.common.utils.data.DateUtils;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

/**
 * Entity基类
 */
public class BaseEntity implements Serializable {
    private static final long serialVersionUID = 1L;

    @TableField(exist = false)
    private Boolean apiFlag = false;

    @TableField(exist = false)
    private Boolean manualUpdate = false;

    public Boolean getApiFlag() {
        return apiFlag;
    }

    public void setApiFlag(Boolean apiFlag) {
        this.apiFlag = apiFlag;
    }

    public Boolean getManualUpdate() {
        return manualUpdate;
    }

    public void setManualUpdate(Boolean manualUpdate) {
        this.manualUpdate = manualUpdate;
    }

    public <T> T deepCopyObj() {
        Class<? extends BaseEntity> aClass = this.getClass();
        Object o = null;
        try {
            o = aClass.getDeclaredConstructor().newInstance();
        } catch (InstantiationException e) {
            throw new RuntimeException(e);
        } catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        } catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        } catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
        BeanUtils.copyProperties(this, o);
        return (T) o;
    }

    public <T extends BaseEntity> T deepSetObj(T t) {
        Object o = t.deepCopyObj();
        DataUtil.copyFieldsAndSetValues(this, o);
        return (T) o;
    }

    public <T> T deepSetObj(Class<T> tClass) {
        T target = this.deepCopyObj(tClass);
        DataUtil.copyFieldsAndSetValues(this, target);
        return target;
    }

    public <T> T deepCopyObj(Class<T> tClass) {
        Object o = null;
        try {
            o = tClass.getDeclaredConstructor().newInstance();
        } catch (InstantiationException e) {
            throw new RuntimeException(e);
        } catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        } catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        } catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
        BeanUtils.copyProperties(this, o);
        return (T) o;
    }

    /**
     * 搜索值
     */
    private transient String searchValue;

    /**
     * 创建者
     */
    private String createBy;

    /**
     * 创建时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date createTime;

    /**
     * 更新者
     */
    private String updateBy;

    /**
     * 更新时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date updateTime;

    public void createAction() {
        if (this.manualUpdate) {
            return;
        }

        String username = null;
        if (this.apiFlag) {
            username = "SAP";
        } else {
            username = SecurityUtils.getUsername();
        }

        Date nowDate = DateUtils.getNowDate();
        if (this.getCreateTime() == null) {
            setCreateTime(nowDate);
        }


        setCreateBy(username);
        setUpdateBy(username);
        setUpdateTime(nowDate);
    }

    public void updateAction() {
        if (this.manualUpdate) {
            return;
        }


        String username = null;
        if (this.apiFlag) {
            username = "SAP";
        } else {
            username = SecurityUtils.getUsername();
        }
        setUpdateBy(username);
        setUpdateTime(DateUtils.getNowDate());
    }

    /**
     * 备注
     */
    private String remark;
    /**
     * 请求参数
     */
    @TableField(exist = false)
    private transient Map<String, Object> params;

    public String getSearchValue() {
        return searchValue;
    }

    public void setSearchValue(String searchValue) {
        this.searchValue = searchValue;
    }

    public String getCreateBy() {
        return createBy;
    }

    public void setCreateBy(String createBy) {
        this.createBy = createBy;
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public String getUpdateBy() {
        return updateBy;
    }

    public void setUpdateBy(String updateBy) {
        this.updateBy = updateBy;
    }

    public Date getUpdateTime() {
        return updateTime;
    }

    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public Map<String, Object> getParams() {
        if (params == null) {
            params = new HashMap<>();
        }
        return params;
    }

    public void setParams(Map<String, Object> params) {
        this.params = params;
    }
}
