package com.ximai.web.controller.system;

import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.ximai.common.annotation.Log;
import com.ximai.common.core.controller.BaseController;
import com.ximai.common.core.domain.AjaxResult;
import com.ximai.common.enums.BusinessType;
import com.ximai.system.domain.SysPrintTemplate;
import com.ximai.system.service.ISysPrintTemplateService;
import com.ximai.common.utils.poi.ExcelUtil;
import com.ximai.common.core.page.TableDataInfo;

/**
 * 打印模板配置Controller
 *
 * @author generator
 * @date 2024-02-28
 */
@RestController
@RequestMapping("/system/printTemplate")
public class SysPrintTemplateController extends BaseController
{
    @Autowired
    private ISysPrintTemplateService sysPrintTemplateService;

    /**
     * 查询打印模板配置列表
     */
    @PreAuthorize("@ss.hasPermi('system:printTemplate:list')")
    @GetMapping("/list")
    public TableDataInfo list(SysPrintTemplate sysPrintTemplate)
    {
        startPage();
        List<SysPrintTemplate> list = sysPrintTemplateService.selectSysPrintTemplateList(sysPrintTemplate);
        return getDataTable(list);
    }

    /**
     * 导出打印模板配置列表
     */
    @PreAuthorize("@ss.hasPermi('system:printTemplate:export')")
    @Log(title = "打印模板配置", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, SysPrintTemplate sysPrintTemplate)
    {
        List<SysPrintTemplate> list = sysPrintTemplateService.selectSysPrintTemplateList(sysPrintTemplate);
        ExcelUtil<SysPrintTemplate> util = new ExcelUtil<SysPrintTemplate>(SysPrintTemplate.class);
        util.exportExcel(response, list, "打印模板配置数据");
    }

    /**
     * 获取打印模板配置详细信息
     */
    @PreAuthorize("@ss.hasPermi('system:printTemplate:query')")
    @GetMapping(value = "/{templateId}")
    public AjaxResult getInfo(@PathVariable("templateId") Long templateId)
    {
        return AjaxResult.success(sysPrintTemplateService.selectSysPrintTemplateByTemplateId(templateId));
    }

    /**
     * 新增打印模板配置
     */
    @PreAuthorize("@ss.hasPermi('system:printTemplate:add')")
    @Log(title = "打印模板配置", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody SysPrintTemplate sysPrintTemplate)
    {
        return toAjax(sysPrintTemplateService.insertSysPrintTemplate(sysPrintTemplate));
    }

    /**
     * 修改打印模板配置
     */
    @PreAuthorize("@ss.hasPermi('system:printTemplate:edit')")
    @Log(title = "打印模板配置", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody SysPrintTemplate sysPrintTemplate)
    {
        return toAjax(sysPrintTemplateService.updateSysPrintTemplate(sysPrintTemplate));
    }

    /**
     * 删除打印模板配置
     */
    @PreAuthorize("@ss.hasPermi('system:printTemplate:remove')")
    @Log(title = "打印模板配置", businessType = BusinessType.DELETE)
	@DeleteMapping("/{templateIds}")
    public AjaxResult remove(@PathVariable Long[] templateIds)
    {
        return toAjax(sysPrintTemplateService.deleteSysPrintTemplateByTemplateIds(templateIds));
    }
}
