package com.ximai.system.service.impl;

import java.util.List;
import com.ximai.common.utils.data.DateUtils;
import com.ximai.common.utils.SecurityUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ximai.system.mapper.SysPrintPrinterConfigMapper;
import com.ximai.system.domain.SysPrintPrinterConfig;
import com.ximai.system.service.ISysPrintPrinterConfigService;

/**
 * 打印机配置Service业务层处理
 *
 * @author generator
 * @date 2024-02-28
 */
@Service
public class SysPrintPrinterConfigServiceImpl implements ISysPrintPrinterConfigService
{
    @Autowired
    private SysPrintPrinterConfigMapper sysPrintPrinterConfigMapper;

    /**
     * 查询打印机配置
     *
     * @param printerId 打印机配置主键
     * @return 打印机配置
     */
    @Override
    public SysPrintPrinterConfig selectSysPrintPrinterConfigByPrinterId(Long printerId)
    {
        return sysPrintPrinterConfigMapper.selectSysPrintPrinterConfigByPrinterId(printerId);
    }

    /**
     * 查询打印机配置列表
     *
     * @param sysPrintPrinterConfig 打印机配置
     * @return 打印机配置
     */
    @Override
    public List<SysPrintPrinterConfig> selectSysPrintPrinterConfigList(SysPrintPrinterConfig sysPrintPrinterConfig)
    {
        return sysPrintPrinterConfigMapper.selectSysPrintPrinterConfigList(sysPrintPrinterConfig);
    }

    /**
     * 新增打印机配置
     *
     * @param sysPrintPrinterConfig 打印机配置
     * @return 结果
     */
    @Override
    public int insertSysPrintPrinterConfig(SysPrintPrinterConfig sysPrintPrinterConfig)
    {
        sysPrintPrinterConfig.setCreateBy(SecurityUtils.getUsername());
        sysPrintPrinterConfig.setCreateTime(DateUtils.getNowDate());
        return sysPrintPrinterConfigMapper.insertSysPrintPrinterConfig(sysPrintPrinterConfig);
    }

    /**
     * 修改打印机配置
     *
     * @param sysPrintPrinterConfig 打印机配置
     * @return 结果
     */
    @Override
    public int updateSysPrintPrinterConfig(SysPrintPrinterConfig sysPrintPrinterConfig)
    {
        sysPrintPrinterConfig.setUpdateBy(SecurityUtils.getUsername());
        sysPrintPrinterConfig.setUpdateTime(DateUtils.getNowDate());
        return sysPrintPrinterConfigMapper.updateSysPrintPrinterConfig(sysPrintPrinterConfig);
    }

    /**
     * 批量删除打印机配置
     *
     * @param printerIds 需要删除的打印机配置主键
     * @return 结果
     */
    @Override
    public int deleteSysPrintPrinterConfigByPrinterIds(Long[] printerIds)
    {
        return sysPrintPrinterConfigMapper.deleteSysPrintPrinterConfigByPrinterIds(printerIds);
    }

    /**
     * 删除打印机配置信息
     *
     * @param printerId 打印机配置主键
     * @return 结果
     */
    @Override
    public int deleteSysPrintPrinterConfigByPrinterId(Long printerId)
    {
        return sysPrintPrinterConfigMapper.deleteSysPrintPrinterConfigByPrinterId(printerId);
    }

}
