package com.bs.mes.schedule.strategy;

import com.ximai.mes.pro.schedule.IOperationTimeCalculator;
import com.ximai.mes.pro.schedule.Job;
import com.ximai.mes.pro.schedule.TaskSchedulingContext;
import com.ximai.mes.pro.schedule.strategy.EvaluateEquipmentShift;
import org.junit.Assert;
import org.junit.Test;

import java.time.Duration;
import java.util.ArrayList;
import java.util.List;

public class EvaluateEquipmentShiftTest {
    @Test public void evaluate(){
        EvaluateEquipmentShift evaluateEquipmentShift = new EvaluateEquipmentShift();
        TaskSchedulingContext context = new TaskSchedulingContext();
        IOperationTimeCalculator.OperationTimePlan operationTimePlan = new IOperationTimeCalculator.OperationTimePlan();
        List<IOperationTimeCalculator.OperationTimePlanItem> operationTimePlanItemList = new ArrayList<IOperationTimeCalculator.OperationTimePlanItem>();
        operationTimePlan.setPlan(operationTimePlanItemList);
        operationTimePlan.setScheduledSuccess(true);
        Job job = new Job("1", Duration.ofMinutes(12));
        job.setProducedDeliveryTime(Duration.ofMinutes(3000));
        context.setJob(job);
        operationTimePlanItemList.add(new IOperationTimeCalculator.OperationTimePlanItem(){{
            setStartedTime(Duration.ofMinutes(2888));
            setEndedTime(Duration.ofMinutes(2898));
            setShiftType("白班");
        }});
        //未切换班组评分为10
        double rst = evaluateEquipmentShift.evaluate(context, operationTimePlan, null);
        Assert.assertEquals(10.0, rst, Double.valueOf(0.001));
        operationTimePlanItemList.add(new IOperationTimeCalculator.OperationTimePlanItem(){{
            setStartedTime(Duration.ofMinutes(2888));
            setEndedTime(Duration.ofMinutes(2900));
            setShiftType("白班");
        }});
        rst = evaluateEquipmentShift.evaluate(context, operationTimePlan, null);
        Assert.assertEquals(10.0, rst, Double.valueOf(0.001));
        //切换1次班组，评分10-1
        operationTimePlanItemList.get(1).setShiftType("中班");
        rst = evaluateEquipmentShift.evaluate(context, operationTimePlan,null);
        Assert.assertEquals(9.0, rst, Double.valueOf(0.001));
        //切换2次班组，评分10-2
        operationTimePlanItemList.add(new IOperationTimeCalculator.OperationTimePlanItem(){{
            setStartedTime(Duration.ofMinutes(3000));
            setEndedTime(Duration.ofMinutes(7000));
            setShiftType("中班");
        }});
        rst = evaluateEquipmentShift.evaluate(context, operationTimePlan, null);
        Assert.assertEquals(8.0, rst, Double.valueOf(0.001));


    }
}
