package com.bs.mes.pro;

import cn.hutool.core.date.DateUtil;
import com.ximai.common.utils.data.DataUtil;
import com.ximai.mes.cal.domain.CalPlanWorkunit;
import com.ximai.mes.pro.domain.ProStartWork;
import com.ximai.mes.pro.schedule.Equipment;
import com.ximai.mes.pro.schedule.strategy.EvaluateEquipmentDeliveryTime;
import com.ximai.mes.pro.service.impl.ProStartWorkServiceImpl;
import org.junit.Assert;
import org.junit.Test;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class ProStartWorkServiceImplTest {

    @Test public void computeWorkTime() throws Exception {
        ProStartWorkServiceImpl proStartWorkService = new ProStartWorkServiceImpl();
        Method methods = ProStartWorkServiceImpl.class.getDeclaredMethod("computeWorkTime", ProStartWork.class, List.class, Long.class);

        methods.setAccessible(true);
        // 测试1 加工时间超出上班时间
        ProStartWork proStartWork = new ProStartWork();
        List<CalPlanWorkunit> calPlanWorkunits = new ArrayList<>();
        proStartWork.setStartDate(DateUtil.parse("2024-11-22 13:53","yyyy-MM-dd HH:mm"));
        proStartWork.setEndDate(DateUtil.parse("2024-11-23 13:03","yyyy-MM-dd HH:mm"));
        calPlanWorkunits.add(new CalPlanWorkunit(){
            {
                setStartDate(DateUtil.parse("2024-11-22 09:00","yyyy-MM-dd HH:mm"));
                setEndDate(DateUtil.parse("2024-11-22 13:00","yyyy-MM-dd HH:mm"));
            };
        });
        calPlanWorkunits.add(new CalPlanWorkunit(){
            {
                setStartDate(DateUtil.parse("2024-11-22 15:00","yyyy-MM-dd HH:mm"));
                setEndDate(DateUtil.parse("2024-11-22 19:00","yyyy-MM-dd HH:mm"));
            };
        });
        calPlanWorkunits.add(new CalPlanWorkunit(){
            {
                setStartDate(DateUtil.parse("2024-11-23 09:00","yyyy-MM-dd HH:mm"));
                setEndDate(DateUtil.parse("2024-11-23 13:00","yyyy-MM-dd HH:mm"));
            };
        });
        calPlanWorkunits.add(new CalPlanWorkunit(){
            {
                setStartDate(DateUtil.parse("2024-11-23 15:00","yyyy-MM-dd HH:mm"));
                setEndDate(DateUtil.parse("2024-11-23 19:00","yyyy-MM-dd HH:mm"));
            };
        });
        Map<String, Long> rst = (Map) methods.invoke(proStartWorkService, proStartWork, calPlanWorkunits, 0l);
        Assert.assertEquals((240+240)*60, rst.get("workTimeSec").longValue());
        Assert.assertEquals((proStartWork.getEndDate().getTime()-proStartWork.getStartDate().getTime())/1000-rst.get("workTimeSec").longValue(),
                rst.get("breakTimeSec").longValue());

        //测试2 加工时间在排班日历范围内
        proStartWork.setEndDate(DateUtil.parse("2024-11-23 12:48","yyyy-MM-dd HH:mm"));
        rst = (Map) methods.invoke(proStartWorkService, proStartWork, calPlanWorkunits, 0l);
        Assert.assertEquals((228+240)*60, rst.get("workTimeSec").longValue());
        Assert.assertEquals((proStartWork.getEndDate().getTime()-proStartWork.getStartDate().getTime())/1000-rst.get("workTimeSec").longValue(),
                rst.get("breakTimeSec").longValue());

        calPlanWorkunits.add(new CalPlanWorkunit(){
            {
                setStartDate(DateUtil.parse("2024-12-03 08:00","yyyy-MM-dd HH:mm"));
                setEndDate(DateUtil.parse("2024-12-03 12:00","yyyy-MM-dd HH:mm"));
            };
        });

        //测试3 时间精确到秒
        proStartWork.setStartDate(DateUtil.parse("2024-12-03 10:19:36","yyyy-MM-dd HH:mm:ss"));
        proStartWork.setEndDate(DateUtil.parse("2024-12-03 10:20:42","yyyy-MM-dd HH:mm:ss"));
        rst = (Map) methods.invoke(proStartWorkService, proStartWork, calPlanWorkunits, 0l);
        Assert.assertEquals(60+6, rst.get("workTimeSec").longValue());
        Assert.assertEquals(0l,
                rst.get("breakTimeSec").longValue());
    }

}
